/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.ResponseSender;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public abstract class Response {
    public static final String DEFAULT_CONTENT_TYPE = "text/html; charset=utf-8";
    protected static final String CRLF = "\r\n";
    private Format format;
    private int status = 200;
    private HashMap<String, String> headers = new HashMap(17);
    private String contentType = "text/html; charset=utf-8";
    private static Map<Integer, String> reasonCodes = new HashMap<Integer, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(100, "Continue");
            this.put(101, "Switching Protocols");
            this.put(200, "OK");
            this.put(201, "Created");
            this.put(202, "Accepted");
            this.put(203, "Non-Authoritative Information");
            this.put(204, "No Content");
            this.put(205, "Reset Content");
            this.put(300, "Multiple Choices");
            this.put(301, "Moved Permanently");
            this.put(302, "Found");
            this.put(303, "See Other");
            this.put(304, "Not Modified");
            this.put(305, "Use Proxy");
            this.put(307, "Temporary Redirect");
            this.put(400, "Bad Request");
            this.put(401, "Unauthorized");
            this.put(402, "Payment Required");
            this.put(403, "Forbidden");
            this.put(404, "Not Found");
            this.put(405, "Method Not Allowed");
            this.put(406, "Not Acceptable");
            this.put(407, "Proxy Authentication Required");
            this.put(408, "Request Time-out");
            this.put(409, "Conflict");
            this.put(410, "Gone");
            this.put(411, "Length Required");
            this.put(412, "Precondition Failed");
            this.put(413, "Request Entity Too Large");
            this.put(414, "Request-URI Too Large");
            this.put(415, "Unsupported Media Type");
            this.put(416, "Requested range not satisfiable");
            this.put(417, "Expectation Failed");
            this.put(500, "Internal Server Error");
            this.put(501, "Not Implemented");
            this.put(502, "Bad Gateway");
            this.put(503, "Service Unavailable");
            this.put(504, "Gateway Time-out");
            this.put(505, "HTTP Version not supported");
        }
    };

    public static SimpleDateFormat makeStandardHttpDateFormat() {
        SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df;
    }

    public Response(String formatString) {
        if (formatString == null) {
            formatString = "html";
        }
        if (formatString.equalsIgnoreCase("html")) {
            this.format = Format.HTML;
            this.setContentType(DEFAULT_CONTENT_TYPE);
        } else if (formatString.equalsIgnoreCase("xml")) {
            this.format = Format.XML;
            this.setContentType("text/xml");
        } else if (formatString.equalsIgnoreCase("text")) {
            this.format = Format.TEXT;
            this.setContentType("text/text");
        } else if (formatString.equalsIgnoreCase("java")) {
            this.format = Format.JAVA;
            this.setContentType("java");
        } else {
            this.format = Format.HTML;
        }
    }

    public Response(String format, int status) {
        this(format);
        this.status = status;
    }

    public boolean isXmlFormat() {
        return this.format == Format.XML;
    }

    public boolean isHtmlFormat() {
        return this.format == Format.HTML;
    }

    public boolean isTextFormat() {
        return this.format == Format.TEXT;
    }

    public boolean isJavaFormat() {
        return this.format == Format.JAVA;
    }

    public abstract void readyToSend(ResponseSender var1) throws Exception;

    protected abstract void addSpecificHeaders();

    public abstract int getContentSize();

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int s) {
        this.status = s;
    }

    public String makeHttpHeaders() {
        StringBuffer text = new StringBuffer();
        if (this.format != Format.TEXT) {
            text.append("HTTP/1.1 ").append(this.status).append(" ").append(this.getReasonPhrase()).append(CRLF);
            this.makeHeaders(text);
            text.append(CRLF);
        }
        return text.toString();
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public void redirect(String location) {
        this.status = 303;
        this.addHeader("Location", location);
    }

    public void setMaxAge(int age) {
        this.addHeader("Cache-Control", "max-age=" + age);
    }

    public void setLastModifiedHeader(String date) {
        this.addHeader("Last-Modified", date);
    }

    public void setExpiresHeader(String date) {
        this.addHeader("Expires", date);
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public String getHeader(String key) {
        return this.headers.get(key);
    }

    public byte[] getEncodedBytes(String value) throws Exception {
        return value.getBytes("UTF-8");
    }

    void makeHeaders(StringBuffer text) {
        for (String key : this.headers.keySet()) {
            String value = this.headers.get(key);
            text.append(key).append(": ").append(value).append(CRLF);
        }
    }

    protected void addStandardHeaders() {
        this.addHeader("Content-Type", this.getContentType());
        this.addSpecificHeaders();
    }

    protected String getReasonPhrase() {
        return Response.getReasonPhrase(this.status);
    }

    public static String getReasonPhrase(int status) {
        String reasonPhrase = reasonCodes.get(status);
        return reasonPhrase == null ? "Unknown Status" : reasonPhrase;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        XML,
        HTML,
        TEXT,
        JAVA;

    }
}

