/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.junit;

import fitnesse.junit.JUnitHelper;
import fitnesse.junit.JUnitRunNotifierResultsListener;
import fitnesse.responders.run.JavaFormatter;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FitNesseSuite
extends ParentRunner<String> {
    private final Class<?> suiteClass;
    private final String suiteName;
    private String fitNesseDir;
    private String outputDir;

    public FitNesseSuite(Class<?> suiteClass, RunnerBuilder builder) throws InitializationError {
        super(suiteClass);
        this.suiteClass = suiteClass;
        this.suiteName = FitNesseSuite.getSuiteName(suiteClass);
        this.fitNesseDir = FitNesseSuite.getFitnesseDir(suiteClass);
        this.outputDir = FitNesseSuite.getOutputDir(suiteClass);
    }

    protected Description describeChild(String child) {
        return Description.createTestDescription(this.suiteClass, (String)child);
    }

    protected List<String> getChildren() {
        return JavaFormatter.getInstance(this.suiteName).getTestsExecuted();
    }

    private static String getFitnesseDir(Class<?> klass) throws InitializationError {
        FitnesseDir fitnesseDirAnnotation = klass.getAnnotation(FitnesseDir.class);
        if (fitnesseDirAnnotation == null) {
            throw new InitializationError("There must be a @FitnesseDir annotation");
        }
        return fitnesseDirAnnotation.value();
    }

    private static String getSuiteName(Class<?> klass) throws InitializationError {
        Name nameAnnotation = klass.getAnnotation(Name.class);
        if (nameAnnotation == null) {
            throw new InitializationError("There must be a @Name annotation");
        }
        return nameAnnotation.value();
    }

    private static String getOutputDir(Class<?> klass) throws InitializationError {
        OutputDir outputDirAnnotation = klass.getAnnotation(OutputDir.class);
        if (outputDirAnnotation == null) {
            throw new InitializationError("There must be a @OutputDir annotation");
        }
        if (!"".equals(outputDirAnnotation.value())) {
            return outputDirAnnotation.value();
        }
        if (!"".equals(outputDirAnnotation.systemProperty())) {
            String baseDir = System.getProperty(outputDirAnnotation.systemProperty());
            File outputDir = new File(baseDir, outputDirAnnotation.pathExtension());
            return outputDir.getAbsolutePath();
        }
        throw new InitializationError("In annotation @OutputDir you have to specify either 'value' or 'systemProperty'");
    }

    public void run(RunNotifier notifier) {
        JUnitHelper helper = new JUnitHelper(this.fitNesseDir, this.outputDir, new JUnitRunNotifierResultsListener(notifier, this.suiteClass));
        try {
            helper.assertSuitePasses(this.suiteName);
        }
        catch (Exception e) {
            notifier.fireTestFailure(new Failure(Description.createSuiteDescription(this.suiteClass), (Throwable)e));
        }
    }

    protected void runChild(String test, RunNotifier notifier) {
        JUnitHelper helper = new JUnitHelper(this.fitNesseDir, this.outputDir, new JUnitRunNotifierResultsListener(notifier, this.suiteClass));
        try {
            helper.assertTestPasses(this.suiteName);
        }
        catch (Exception e) {
            notifier.fireTestFailure(new Failure(Description.createSuiteDescription(this.suiteClass), (Throwable)e));
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface OutputDir {
        public String value() default "";

        public String systemProperty() default "";

        public String pathExtension() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface FitnesseDir {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Name {
        public String value();
    }
}

