/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.NotFoundResponder;
import fitnesse.responders.WikiImportProperty;
import fitnesse.responders.WikiImporter;
import fitnesse.responders.WikiImporterClient;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VirtualEnabledPageCrawler;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;

public class ImportAndViewResponder
implements SecureResponder,
WikiImporterClient {
    private WikiPage page;

    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        String resource = request.getResource();
        if ("".equals(resource)) {
            resource = "FrontPage";
        }
        this.loadPage(resource, context);
        if (this.page == null) {
            return new NotFoundResponder().makeResponse(context, request);
        }
        this.loadPageData();
        SimpleResponse response = new SimpleResponse();
        response.redirect(resource);
        return response;
    }

    protected void loadPage(String resource, FitNesseContext context) throws Exception {
        WikiPagePath path = PathParser.parse(resource);
        PageCrawler crawler = context.root.getPageCrawler();
        crawler.setDeadEndStrategy(new VirtualEnabledPageCrawler());
        this.page = crawler.getPage(context.root, path);
    }

    protected void loadPageData() throws Exception {
        PageData pageData = this.page.getData();
        WikiImportProperty importProperty = WikiImportProperty.createFrom(pageData.getProperties());
        if (importProperty != null) {
            WikiImporter importer = new WikiImporter();
            importer.setWikiImporterClient(this);
            importer.parseUrl(importProperty.getSourceUrl());
            importer.importRemotePageContent(this.page);
        }
    }

    public void pageImported(WikiPage localPage) throws Exception {
    }

    public void pageImportError(WikiPage localPage, Exception e) throws Exception {
        e.printStackTrace();
    }

    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

