/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.responders.WikiImporter;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import java.util.Iterator;

public class MockWikiImporter
extends WikiImporter {
    public static String mockContent = "mock importer content";
    public boolean fail;

    protected void importRemotePageContent(WikiPage localPage) throws Exception {
        if (this.fail) {
            this.importerClient.pageImportError(localPage, new Exception("blah"));
        } else {
            this.setMockContent(localPage);
        }
    }

    private void setMockContent(WikiPage localPage) throws Exception {
        PageData data = localPage.getData();
        data.setContent(mockContent);
        localPage.commit(data);
    }

    public void importWiki(WikiPage page) throws Exception {
        PageCrawler pageCrawler = page.getPageCrawler();
        Iterator<WikiPage> iterator = page.getChildren().iterator();
        while (iterator.hasNext()) {
            pageCrawler.traverse(iterator.next(), this);
        }
    }

    public void processPage(WikiPage page) throws Exception {
        this.setMockContent(page);
    }
}

