/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.responders.BasicWikiPageResponder;
import fitnesse.wiki.WikiPage;
import java.util.ArrayList;
import org.json.JSONArray;
import util.StringUtil;

public class NameWikiPageResponder
extends BasicWikiPageResponder {
    protected String contentFrom(WikiPage requestedPage) throws Exception {
        ArrayList<String> pages = new ArrayList<String>();
        for (WikiPage child : requestedPage.getChildren()) {
            if (this.request.hasInput("ShowChildCount")) {
                String name = child.getName() + " " + Integer.toString(child.getChildren().size());
                pages.add(name);
                continue;
            }
            pages.add(child.getName());
        }
        String format = (String)this.request.getInput("format");
        if ("json".equalsIgnoreCase(format)) {
            JSONArray jsonPages = new JSONArray(pages);
            return jsonPages.toString();
        }
        return StringUtil.join(pages, System.getProperty("line.separator"));
    }

    protected String getContentType() {
        return "text/plain";
    }

    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

