/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import java.util.regex.Pattern;

public class NotFoundResponder
implements Responder {
    private String resource;

    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        SimpleResponse response = new SimpleResponse(404);
        this.resource = request.getResource();
        response.setContent(this.makeHtml(context));
        return response;
    }

    private String makeHtml(FitNesseContext context) throws Exception {
        HtmlPage page = context.htmlPageFactory.newPage();
        HtmlUtil.addTitles(page, "Not Found:" + this.resource);
        page.main.use(this.makeRightColumn(this.resource));
        return page.html();
    }

    private String makeRightColumn(String name) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append("The requested resource: <i>" + name + "</i> was not found.");
        if (Pattern.matches("(?:[<>^.])?(?:\\b[A-Z](?:[a-z0-9]+[A-Z][a-z0-9]*)+[.]?)+\\b", name)) {
            this.makeCreateThisPageWithButton(name, buffer);
        }
        return buffer.toString();
    }

    private void makeCreateThisPageWithButton(String name, StringBuffer buffer) throws Exception {
        HtmlTag createPageForm = HtmlUtil.makeFormTag("POST", name + "?edit", "createPageForm");
        HtmlTag submitButton = HtmlUtil.makeInputTag("submit", "createPageSubmit", "Create This Page");
        submitButton.addAttribute("accesskey", "c");
        createPageForm.add(submitButton);
        buffer.append(HtmlUtil.BR);
        buffer.append(HtmlUtil.BR);
        buffer.append(createPageForm.html());
    }
}

