/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.authentication.SecureWriteOperation;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.html.TagGroup;
import fitnesse.http.ChunkedResponse;
import fitnesse.responders.ChunkingResponder;
import fitnesse.responders.WikiImportProperty;
import fitnesse.responders.WikiImporter;
import fitnesse.responders.WikiImporterClient;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.util.List;

public class WikiImportingResponder
extends ChunkingResponder
implements SecureResponder,
WikiImporterClient {
    private int alternation = 0;
    private boolean isUpdate;
    private boolean isNonRoot;
    public PageData data;
    private WikiImporter importer = new WikiImporter();

    public void setImporter(WikiImporter importer) {
        this.importer = importer;
    }

    protected void doSending() throws Exception {
        this.data = this.page.getData();
        HtmlPage html = this.makeHtml();
        this.response.add(html.preDivision);
        try {
            this.initializeImporter();
            this.addHeadContent();
            if (this.isNonRoot) {
                this.importer.importRemotePageContent(this.page);
            }
            this.importer.importWiki(this.page);
            this.addTailContent();
            if (!this.isUpdate) {
                WikiImportProperty importProperty = new WikiImportProperty(this.importer.remoteUrl());
                importProperty.setRoot(true);
                importProperty.setAutoUpdate(this.importer.getAutoUpdateSetting());
                importProperty.addTo(this.data.getProperties());
                this.page.commit(this.data);
            }
        }
        catch (MalformedURLException e) {
            this.writeErrorMessage(e);
        }
        catch (FileNotFoundException e) {
            this.writeErrorMessage("The remote resource, " + this.importer.remoteUrl() + ", was not found.");
        }
        catch (WikiImporter.AuthenticationRequiredException e) {
            this.writeAuthenticationForm(e.getMessage());
        }
        catch (Exception e) {
            this.writeErrorMessage(e);
        }
        this.response.add(html.postDivision);
        this.response.closeAll();
    }

    public void initializeImporter() throws Exception {
        String remoteWikiUrl = this.establishRemoteUrlAndUpdateStyle();
        this.importer.setWikiImporterClient(this);
        this.importer.setLocalPath(this.path);
        this.importer.parseUrl(remoteWikiUrl);
        this.setRemoteUserCredentialsOnImporter();
        this.importer.setAutoUpdateSetting(this.request.hasInput("autoUpdate"));
    }

    private void setRemoteUserCredentialsOnImporter() {
        if (this.request.hasInput("remoteUsername")) {
            this.importer.setRemoteUsername((String)this.request.getInput("remoteUsername"));
        }
        if (this.request.hasInput("remotePassword")) {
            this.importer.setRemotePassword((String)this.request.getInput("remotePassword"));
        }
    }

    private String establishRemoteUrlAndUpdateStyle() throws Exception {
        String remoteWikiUrl = (String)this.request.getInput("remoteUrl");
        WikiImportProperty importProperty = WikiImportProperty.createFrom(this.data.getProperties());
        if (importProperty != null) {
            remoteWikiUrl = importProperty.getSourceUrl();
            this.isUpdate = true;
            this.isNonRoot = !importProperty.isRoot();
        }
        return remoteWikiUrl;
    }

    private void writeErrorMessage(String message) throws Exception {
        HtmlTag alert = HtmlUtil.makeDivTag("centered");
        alert.add(new HtmlTag("h2", "Import Failure"));
        alert.add(message);
        this.response.add(alert.html());
    }

    private void writeErrorMessage(Exception e) throws Exception {
        this.writeErrorMessage(e.getMessage());
        HtmlTag pre = new HtmlTag("pre");
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(output);
        e.printStackTrace(printStream);
        printStream.flush();
        pre.add(new String(output.toByteArray()));
        this.response.add(pre.html());
    }

    private void addHeadContent() throws Exception {
        TagGroup head = new TagGroup();
        if (this.isUpdate) {
            head.add("Updating imported wiki.");
        } else {
            head.add("Importing wiki.");
        }
        head.add(" This may take a few moments.");
        head.add(HtmlUtil.BR);
        head.add(HtmlUtil.BR);
        head.add("Destination wiki: ");
        String pageName = PathParser.render(this.path);
        head.add(HtmlUtil.makeLink(pageName, pageName));
        head.add(HtmlUtil.BR);
        head.add("Source wiki: ");
        String remoteWikiUrl = this.importer.remoteUrl();
        head.add(HtmlUtil.makeLink(remoteWikiUrl, remoteWikiUrl));
        head.add(HtmlUtil.BR);
        head.add(HtmlUtil.BR);
        head.add("Imported pages:");
        head.add(HtmlUtil.HR);
        this.response.add(head.html());
    }

    private void addTailContent() throws Exception {
        TagGroup tail = this.makeTailHtml(this.importer);
        this.response.add(tail.html());
    }

    public TagGroup makeTailHtml(WikiImporter importer) throws Exception {
        TagGroup tail = new TagGroup();
        tail.add("<a name=\"end\"><hr></a>");
        tail.add(HtmlUtil.makeBold("Import complete. "));
        this.addUnmodifiedCount(importer, tail);
        tail.add(HtmlUtil.BR);
        this.addImportedPageCount(importer, tail);
        this.addOrphanedPageSection(importer, tail);
        this.addAutoUpdateMessage(importer, tail);
        return tail;
    }

    private void addAutoUpdateMessage(WikiImporter importer, TagGroup tail) {
        tail.add(HtmlUtil.BR);
        String message = "Automatic Update turned " + (importer.getAutoUpdateSetting() ? "ON" : "OFF");
        tail.add(message);
    }

    private void addUnmodifiedCount(WikiImporter importer, TagGroup tail) {
        if (importer.getUnmodifiedCount() != 0) {
            tail.add(HtmlUtil.BR);
            if (importer.getUnmodifiedCount() == 1) {
                tail.add("1 page was unmodified.");
            } else {
                tail.add(importer.getUnmodifiedCount() + " pages were unmodified.");
            }
        }
    }

    private void addImportedPageCount(WikiImporter importer, TagGroup tail) {
        if (importer.getImportCount() == 1) {
            tail.add("1 page was imported.");
        } else {
            tail.add(importer.getImportCount() + " pages were imported.");
        }
    }

    private void addOrphanedPageSection(WikiImporter importer, TagGroup tail) {
        List<WikiPagePath> orphans = importer.getOrphans();
        if (orphans.size() > 0) {
            tail.add(HtmlUtil.BR);
            if (orphans.size() == 1) {
                tail.add("1 orphaned page was found and has been removed.");
            } else {
                tail.add(orphans.size() + " orphaned pages were found and have been removed.");
            }
            tail.add(" This may occur when a remote page is deleted, moved, or renamed.");
            tail.add(HtmlUtil.BR);
            tail.add(HtmlUtil.BR);
            tail.add("Orphans:");
            tail.add(HtmlUtil.HR);
            for (WikiPagePath path : orphans) {
                HtmlTag row = this.alternatingRow();
                row.add(PathParser.render(path));
                tail.add(row);
            }
            tail.add(HtmlUtil.HR);
        }
    }

    private HtmlPage makeHtml() throws Exception {
        HtmlPage html = this.context.htmlPageFactory.newPage();
        html = this.context.htmlPageFactory.newPage();
        String title = "Wiki Import";
        if (this.isUpdate) {
            title = title + " Update";
        }
        String localPathName = PathParser.render(this.path);
        html.title.use(title + ": " + localPathName);
        html.header.use(HtmlUtil.makeBreadCrumbsWithPageType(localPathName, title));
        html.main.add("<!--BREAKPOINT-->");
        html.divide();
        return html;
    }

    protected PageCrawler getPageCrawler() {
        return this.root.getPageCrawler();
    }

    private void addRowToResponse(String status) throws Exception {
        HtmlTag tag = this.alternatingRow();
        String relativePathName = PathParser.render(this.importer.getRelativePath());
        String localPathName = PathParser.render(this.importer.getLocalPath());
        tag.add(HtmlUtil.makeLink(localPathName, relativePathName));
        tag.add(" " + status);
        this.response.add(tag.html());
    }

    private HtmlTag alternatingRow() {
        return HtmlUtil.makeDivTag("alternating_row_" + this.alternate());
    }

    private int alternate() {
        this.alternation = this.alternation % 2 + 1;
        return this.alternation;
    }

    public void setResponse(ChunkedResponse response) {
        this.response = response;
    }

    public SecureOperation getSecureOperation() {
        return new SecureWriteOperation();
    }

    private void writeAuthenticationForm(String resource) throws Exception {
        HtmlTag html = HtmlUtil.makeDivTag("centered");
        html.add(new HtmlTag("h3", "The wiki at " + resource + " requires authentication."));
        html.add(HtmlUtil.BR);
        HtmlTag form = new HtmlTag("form");
        form.addAttribute("action", this.request.getResource());
        form.addAttribute("method", "post");
        form.add(HtmlUtil.makeInputTag("hidden", "responder", "import"));
        if (this.request.hasInput("remoteUrl")) {
            form.add(HtmlUtil.makeInputTag("hidden", "remoteUrl", (String)this.request.getInput("remoteUrl")));
        }
        form.add("remote username: ");
        form.add(HtmlUtil.makeInputTag("text", "remoteUsername"));
        form.add(HtmlUtil.BR);
        form.add("remote password: ");
        form.add(HtmlUtil.makeInputTag("password", "remotePassword"));
        form.add(HtmlUtil.BR);
        form.add(HtmlUtil.makeInputTag("submit", "submit", "Authenticate and Continue Import"));
        html.add(form);
        this.response.add(html.html());
    }

    public void pageImported(WikiPage localPage) throws Exception {
        this.addRowToResponse("");
    }

    public void pageImportError(WikiPage localPage, Exception e) throws Exception {
        this.addRowToResponse(e.toString());
    }

    public WikiImporter getImporter() {
        return this.importer;
    }
}

