/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.components.SaveRecorder;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wikitext.Utils;

public class MergeResponder
implements Responder {
    private Request request;
    private String newContent;
    private String existingContent;
    private String resource;
    private static final String OLD_CONTENT_INPUT_NAME = "oldContent";

    public MergeResponder(Request request) {
        this.request = request;
    }

    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        SimpleResponse response = new SimpleResponse();
        this.resource = this.request.getResource();
        WikiPagePath path = PathParser.parse(this.resource);
        WikiPage page = context.root.getPageCrawler().getPage(context.root, path);
        this.existingContent = page.getData().getContent();
        this.newContent = (String)this.request.getInput("pageContent");
        response.setContent(this.makePageHtml(context));
        return response;
    }

    private String makePageHtml(FitNesseContext context) throws Exception {
        HtmlPage page = context.htmlPageFactory.newPage();
        page.title.use("Merge " + this.resource);
        page.header.use(HtmlUtil.makeBreadCrumbsWithPageType(this.resource, "Merge Changes"));
        page.main.use(this.makeRightColumn());
        return page.html();
    }

    private String makeRightColumn() throws Exception {
        HtmlTag form = HtmlUtil.makeFormTag("post", this.resource);
        form.add(HtmlUtil.makeInputTag("hidden", "responder", "saveData"));
        form.add(HtmlUtil.makeInputTag("hidden", "editTime", String.valueOf(SaveRecorder.timeStamp())));
        form.add(HtmlUtil.makeInputTag("hidden", "ticketId", String.valueOf(SaveRecorder.newTicket())));
        HtmlTag title = HtmlUtil.makeDivTag("centered");
        title.use("This page has been recently modified.  You may want to merge existing page content into your changes.");
        form.add(title);
        form.add(this.makeMergeNewDivTag());
        form.add(this.makeMergeOldDivTag());
        form.add(this.addHiddenAttributes());
        return form.html();
    }

    private HtmlTag makeMergeOldDivTag() {
        HtmlTag mergeOld = HtmlUtil.makeDivTag("merge_old");
        mergeOld.add("Existing Content (read only)");
        mergeOld.add(HtmlUtil.BR);
        mergeOld.add(this.makeOldContentTextArea());
        return mergeOld;
    }

    private HtmlTag makeOldContentTextArea() {
        HtmlTag oldContentTextArea = new HtmlTag("textarea");
        oldContentTextArea.addAttribute("class", OLD_CONTENT_INPUT_NAME);
        oldContentTextArea.addAttribute("name", OLD_CONTENT_INPUT_NAME);
        oldContentTextArea.addAttribute("rows", "25");
        oldContentTextArea.addAttribute("cols", "50");
        oldContentTextArea.addAttribute("readonly", "readonly");
        oldContentTextArea.add(Utils.escapeHTML(this.existingContent));
        return oldContentTextArea;
    }

    private HtmlTag makeMergeNewDivTag() {
        HtmlTag mergeNew = HtmlUtil.makeDivTag("merge_new");
        mergeNew.add("Your Changes");
        mergeNew.add(HtmlUtil.BR);
        mergeNew.add(this.makeContentTextArea());
        mergeNew.add(this.makeInputTagWithAccessKey());
        return mergeNew;
    }

    private HtmlTag makeInputTagWithAccessKey() {
        HtmlTag input = HtmlUtil.makeInputTag("submit", "submit", "Save");
        input.addAttribute("accesskey", "s");
        return input;
    }

    private HtmlTag makeContentTextArea() {
        HtmlTag contentTextArea = new HtmlTag("textarea");
        contentTextArea.addAttribute("name", "pageContent");
        contentTextArea.addAttribute("rows", "25");
        contentTextArea.addAttribute("cols", "50");
        contentTextArea.add(this.newContent);
        return contentTextArea;
    }

    private String addHiddenAttributes() {
        StringBuffer buffer = new StringBuffer();
        if (this.request.hasInput("PageType")) {
            String pageType = (String)this.request.getInput("PageType");
            buffer.append("<input type=\"hidden\" name=\"PageType\" value=\"" + pageType + "\" checked=\"checked\">");
        }
        for (int i = 0; i < PageData.NON_SECURITY_ATTRIBUTES.length; ++i) {
            String attribute = PageData.NON_SECURITY_ATTRIBUTES[i];
            if (!this.request.hasInput(attribute)) continue;
            buffer.append("<input type=\"hidden\" name=\"" + attribute + "\" value=\"On\">");
        }
        return buffer.toString();
    }
}

