/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.authentication.SecureWriteOperation;
import fitnesse.components.RecentChanges;
import fitnesse.components.SaveRecorder;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.editing.ContentFilter;
import fitnesse.responders.editing.MergeResponder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;

public class SaveResponder
implements SecureResponder {
    public static ContentFilter contentFilter;
    private String user;
    private long ticketId;
    private String savedContent;
    private PageData data;
    private long editTimeStamp;

    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        this.editTimeStamp = this.getEditTime(request);
        this.ticketId = this.getTicketId(request);
        String resource = request.getResource();
        WikiPage page = this.getPage(resource, context);
        this.data = page.getData();
        this.user = request.getAuthorizationUsername();
        if (this.editsNeedMerge()) {
            return new MergeResponder(request).makeResponse(context, request);
        }
        this.savedContent = (String)request.getInput("pageContent");
        if (contentFilter != null && !contentFilter.isContentAcceptable(this.savedContent, resource)) {
            return this.makeBannedContentResponse(context, resource);
        }
        return this.saveEdits(request, page);
    }

    private Response makeBannedContentResponse(FitNesseContext context, String resource) throws Exception {
        SimpleResponse response = new SimpleResponse();
        HtmlPage html = context.htmlPageFactory.newPage();
        html.title.use("Edit " + resource);
        html.header.use(HtmlUtil.makeBreadCrumbsWithPageType(resource, "Banned Content"));
        html.main.use(new HtmlTag("h3", "The content you're trying to save has been banned from this site.  Your changes will not be saved!"));
        response.setContent(html.html());
        return response;
    }

    private Response saveEdits(Request request, WikiPage page) throws Exception {
        SimpleResponse response = new SimpleResponse();
        this.setData();
        VersionInfo commitRecord = page.commit(this.data);
        response.addHeader("Previous-Version", commitRecord.getName());
        RecentChanges.updateRecentChanges(this.data);
        if (request.hasInput("redirect")) {
            response.redirect(request.getInput("redirect").toString());
        } else {
            response.redirect(request.getResource());
        }
        return response;
    }

    private boolean editsNeedMerge() throws Exception {
        return SaveRecorder.changesShouldBeMerged(this.editTimeStamp, this.ticketId, this.data);
    }

    private long getTicketId(Request request) {
        if (!request.hasInput("ticketId")) {
            return 0L;
        }
        String ticketIdString = (String)request.getInput("ticketId");
        return Long.parseLong(ticketIdString);
    }

    private long getEditTime(Request request) {
        if (!request.hasInput("editTime")) {
            return 0L;
        }
        String editTimeStampString = (String)request.getInput("editTime");
        long editTimeStamp = Long.parseLong(editTimeStampString);
        return editTimeStamp;
    }

    private WikiPage getPage(String resource, FitNesseContext context) throws Exception {
        WikiPagePath path = PathParser.parse(resource);
        PageCrawler pageCrawler = context.root.getPageCrawler();
        WikiPage page = pageCrawler.getPage(context.root, path);
        if (page == null) {
            page = pageCrawler.addPage(context.root, PathParser.parse(resource));
        }
        return page;
    }

    private void setData() throws Exception {
        this.data.setContent(this.savedContent);
        SaveRecorder.pageSaved(this.data, this.ticketId);
        if (this.user != null) {
            this.data.setAttribute("LastModifyingUser", this.user);
        } else {
            this.data.removeAttribute("LastModifyingUser");
        }
    }

    public SecureOperation getSecureOperation() {
        return new SecureWriteOperation();
    }
}

