/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.ErrorResponder;
import fitnesse.responders.NotFoundResponder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wiki.WikiPageProperty;
import fitnesse.wikitext.Utils;
import fitnesse.wikitext.widgets.WikiWordWidget;
import java.io.File;
import util.StringUtil;

public class SymbolicLinkResponder
implements Responder {
    private Response response;
    private String resource;
    private PageCrawler crawler;
    private FitNesseContext context;
    private WikiPage page;

    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        this.resource = request.getResource();
        this.context = context;
        this.crawler = context.root.getPageCrawler();
        this.page = this.crawler.getPage(context.root, PathParser.parse(this.resource));
        if (this.page == null) {
            return new NotFoundResponder().makeResponse(context, request);
        }
        this.response = new SimpleResponse();
        if (request.hasInput("removal")) {
            this.removeSymbolicLink(request, this.page);
        } else if (request.hasInput("rename")) {
            this.renameSymbolicLink(request, this.page);
        } else {
            this.addSymbolicLink(request, this.page);
        }
        return this.response;
    }

    private void setRedirect(String resource) {
        this.response.redirect(resource + "?properties");
    }

    private void removeSymbolicLink(Request request, WikiPage page) throws Exception {
        String linkToRemove = (String)request.getInput("removal");
        PageData data = page.getData();
        WikiPageProperties properties = data.getProperties();
        WikiPageProperty symLinks = this.getSymLinkProperty(properties);
        symLinks.remove(linkToRemove);
        if (symLinks.keySet().size() == 0) {
            properties.remove("SymbolicLinks");
        }
        page.commit(data);
        this.setRedirect(this.resource);
    }

    private void renameSymbolicLink(Request request, WikiPage page) throws Exception {
        String linkToRename = (String)request.getInput("rename");
        String newName = (String)request.getInput("newname");
        if (page.hasChildPage(newName)) {
            this.response = new ErrorResponder(this.resource + " already has a child named " + newName + ".").makeResponse(this.context, null);
            this.response.setStatus(412);
        } else {
            PageData data = page.getData();
            WikiPageProperties properties = data.getProperties();
            WikiPageProperty symLinks = this.getSymLinkProperty(properties);
            String currentPath = symLinks.get(linkToRename);
            symLinks.remove(linkToRename);
            symLinks.set(newName, currentPath);
            page.commit(data);
            this.setRedirect(this.resource);
        }
    }

    private void addSymbolicLink(Request request, WikiPage page) throws Exception {
        String linkName = StringUtil.trimNonNullString((String)request.getInput("linkName"));
        String linkPath = StringUtil.trimNonNullString((String)request.getInput("linkPath"));
        if (this.isFilePath(linkPath) && !this.isValidDirectoryPath(linkPath)) {
            String message = "Cannot create link to the file system path, <b>" + linkPath + "</b>." + "<br/> The canonical file system path used was <b>" + this.createFileFromPath(linkPath).getCanonicalPath() + ".</b>" + "<br/>Either it doesn't exist or it's not a directory.";
            this.response = new ErrorResponder(message).makeResponse(this.context, null);
            this.response.setStatus(404);
        } else if (!this.isFilePath(linkPath) && this.isInternalPageThatDoesntExist(linkPath)) {
            this.response = new ErrorResponder("The page to which you are attempting to link, " + Utils.escapeHTML(linkPath) + ", doesn't exist.").makeResponse(this.context, null);
            this.response.setStatus(404);
        } else if (page.hasChildPage(linkName)) {
            this.response = new ErrorResponder(this.resource + " already has a child named " + linkName + ".").makeResponse(this.context, null);
            this.response.setStatus(412);
        } else {
            PageData data = page.getData();
            WikiPageProperties properties = data.getProperties();
            WikiPageProperty symLinks = this.getSymLinkProperty(properties);
            symLinks.set(linkName, linkPath);
            page.commit(data);
            this.setRedirect(this.resource);
        }
    }

    private boolean isValidDirectoryPath(String linkPath) throws Exception {
        File file = this.createFileFromPath(linkPath);
        if (file.exists()) {
            return file.isDirectory();
        }
        File parentDir = file.getParentFile();
        return parentDir.exists() && parentDir.isDirectory();
    }

    private File createFileFromPath(String linkPath) {
        String pathToFile = linkPath.substring(7);
        return new File(pathToFile);
    }

    private boolean isFilePath(String linkPath) {
        return linkPath.startsWith("file://");
    }

    private boolean isInternalPageThatDoesntExist(String linkPath) throws Exception {
        String expandedPath = WikiWordWidget.expandPrefix(this.page, linkPath);
        WikiPagePath path = PathParser.parse(expandedPath);
        WikiPage start = path.isRelativePath() ? this.page.getParent() : this.page;
        return !this.crawler.pageExists(start, path);
    }

    private WikiPageProperty getSymLinkProperty(WikiPageProperties properties) {
        WikiPageProperty symLinks = properties.getProperty("SymbolicLinks");
        if (symLinks == null) {
            symLinks = properties.set("SymbolicLinks");
        }
        return symLinks;
    }
}

