/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.files;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.http.InputStreamResponse;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.NotFoundResponder;
import fitnesse.responders.files.DirectoryResponder;
import java.io.File;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.Date;

public class FileResponder
implements Responder {
    private static FileNameMap fileNameMap = URLConnection.getFileNameMap();
    public String resource;
    public File requestedFile;
    public Date lastModifiedDate;
    public String lastModifiedDateString;

    public static Responder makeResponder(Request request, String rootPath) throws Exception {
        File requestedFile;
        String resource = request.getResource();
        if (FileResponder.fileNameHasSpaces(resource)) {
            resource = FileResponder.restoreRealSpacesInFileName(resource);
        }
        if (!(requestedFile = new File(rootPath + "/" + resource)).exists()) {
            return new NotFoundResponder();
        }
        if (requestedFile.isDirectory()) {
            return new DirectoryResponder(resource, requestedFile);
        }
        return new FileResponder(resource, requestedFile);
    }

    public FileResponder(String resource, File requestedFile) {
        this.resource = resource;
        this.requestedFile = requestedFile;
    }

    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        InputStreamResponse response = new InputStreamResponse();
        this.determineLastModifiedInfo();
        if (this.isNotModified(request)) {
            return this.createNotModifiedResponse();
        }
        response.setBody(this.requestedFile);
        this.setContentType(this.requestedFile, response);
        response.setLastModifiedHeader(this.lastModifiedDateString);
        return response;
    }

    public static boolean fileNameHasSpaces(String resource) {
        return resource.indexOf("%20") != 0;
    }

    public static String restoreRealSpacesInFileName(String resource) throws Exception {
        return URLDecoder.decode(resource, "UTF-8");
    }

    String getResource() {
        return this.resource;
    }

    private boolean isNotModified(Request request) {
        if (request.hasHeader("If-Modified-Since")) {
            String queryDateString = (String)request.getHeader("If-Modified-Since");
            try {
                Date queryDate = SimpleResponse.makeStandardHttpDateFormat().parse(queryDateString);
                if (!queryDate.before(this.lastModifiedDate)) {
                    return true;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return false;
    }

    private Response createNotModifiedResponse() {
        SimpleResponse response = new SimpleResponse();
        response.setStatus(304);
        response.addHeader("Date", SimpleResponse.makeStandardHttpDateFormat().format(new Date()));
        response.addHeader("Cache-Control", "private");
        response.setLastModifiedHeader(this.lastModifiedDateString);
        return response;
    }

    private void determineLastModifiedInfo() {
        this.lastModifiedDate = new Date(this.requestedFile.lastModified());
        this.lastModifiedDateString = SimpleResponse.makeStandardHttpDateFormat().format(this.lastModifiedDate);
        try {
            this.lastModifiedDate = SimpleResponse.makeStandardHttpDateFormat().parse(this.lastModifiedDateString);
        }
        catch (ParseException jtpe) {
            jtpe.printStackTrace();
        }
    }

    private void setContentType(File file, Response response) {
        String contentType = FileResponder.getContentType(file.getName());
        response.setContentType(contentType);
    }

    public static String getContentType(String filename) {
        String contentType = fileNameMap.getContentTypeFor(filename);
        if (contentType == null) {
            contentType = filename.endsWith(".css") ? "text/css" : (filename.endsWith(".jar") ? "application/x-java-archive" : "text/plain");
        }
        return contentType;
    }
}

