/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.files;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.http.UploadedFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import util.FileUtil;

public class UploadResponder
implements SecureResponder {
    private static final Pattern filenamePattern = Pattern.compile("([^/\\\\]*[/\\\\])*([^/\\\\]*)");
    private String rootPath;

    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        this.rootPath = context.rootPagePath;
        SimpleResponse response = new SimpleResponse();
        String resource = request.getResource().replace("%20", " ");
        UploadedFile uploadedFile = (UploadedFile)request.getInput("file");
        if (uploadedFile.isUsable()) {
            File file = this.makeFileToCreate(uploadedFile, resource);
            this.writeFile(file, uploadedFile);
        }
        response.redirect("/" + resource.replace(" ", "%20"));
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(File file, UploadedFile uploadedFile) throws Exception {
        boolean renamed = uploadedFile.getFile().renameTo(file);
        if (!renamed) {
            InputStream input = null;
            OutputStream output = null;
            try {
                input = new BufferedInputStream(new FileInputStream(uploadedFile.getFile()));
                output = new BufferedOutputStream(new FileOutputStream(file));
                FileUtil.copyBytes(input, output);
            }
            finally {
                input.close();
                output.close();
                uploadedFile.delete();
            }
        }
    }

    private File makeFileToCreate(UploadedFile uploadedFile, String resource) {
        String relativeFilename;
        String filename = relativeFilename = UploadResponder.makeRelativeFilename(uploadedFile.getName());
        int prefix = 1;
        File file = new File(this.makeFullFilename(resource, filename));
        while (file.exists()) {
            filename = UploadResponder.makeNewFilename(relativeFilename, prefix++);
            file = new File(this.makeFullFilename(resource, filename));
        }
        return file;
    }

    private String makeFullFilename(String resource, String filename) {
        return this.rootPath + "/" + resource + filename;
    }

    public static String makeRelativeFilename(String name) {
        Matcher match = filenamePattern.matcher(name);
        if (match.find()) {
            return match.group(2);
        }
        return name;
    }

    public static String makeNewFilename(String filename, int copyId) {
        String[] parts = filename.split("\\.");
        if (parts.length == 1) {
            return filename + "_copy" + copyId;
        }
        String newName = "";
        for (int i = 0; i < parts.length - 1; ++i) {
            if (i != 0) {
                newName = newName + ".";
            }
            newName = newName + parts[i];
        }
        newName = newName + "_copy" + copyId + "." + parts[parts.length - 1];
        return newName;
    }

    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

