/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.refactoring;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.html.RawHtml;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.List;

public class DeletePageResponder
implements SecureResponder {
    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        SimpleResponse response = new SimpleResponse();
        String qualifiedPageName = request.getResource();
        WikiPagePath path = PathParser.parse(qualifiedPageName);
        if ("FrontPage".equals(qualifiedPageName)) {
            response.redirect("FrontPage");
            return response;
        }
        String confirmedString = (String)request.getInput("confirmed");
        if (!"yes".equals(confirmedString)) {
            response.setContent(this.buildConfirmationHtml(context.root, qualifiedPageName, context));
            return response;
        }
        String nameOfPageToBeDeleted = path.last();
        path.removeNameFromEnd();
        WikiPage parentOfPageToBeDeleted = context.root.getPageCrawler().getPage(context.root, path);
        if (parentOfPageToBeDeleted != null) {
            parentOfPageToBeDeleted.removeChildPage(nameOfPageToBeDeleted);
        }
        this.redirect(path, response);
        return response;
    }

    private void redirect(WikiPagePath path, SimpleResponse response) {
        String location = PathParser.render(path);
        if (location == null || location.length() == 0) {
            response.redirect("root");
        } else {
            response.redirect(location);
        }
    }

    private String buildConfirmationHtml(WikiPage root, String qualifiedPageName, FitNesseContext context) throws Exception {
        HtmlPage html = context.htmlPageFactory.newPage();
        html.title.use("Delete Confirmation");
        html.header.use(HtmlUtil.makeBreadCrumbsWithPageType(qualifiedPageName, "/", "Confirm Deletion"));
        html.main.use(this.makeMainContent(root, qualifiedPageName));
        return html.html();
    }

    private String makeMainContent(WikiPage root, String qualifiedPageName) throws Exception {
        WikiPagePath path = PathParser.parse(qualifiedPageName);
        WikiPage pageToDelete = root.getPageCrawler().getPage(root, path);
        List<WikiPage> children = pageToDelete.getChildren();
        boolean addSubPageWarning = true;
        if (children == null || children.isEmpty()) {
            addSubPageWarning = false;
        }
        HtmlTag divTag = HtmlUtil.makeDivTag("centered");
        divTag.add(this.makeHeadingTag(addSubPageWarning, qualifiedPageName));
        divTag.add(HtmlUtil.BR);
        divTag.add(new RawHtml("<center><table class = \"confirmation-form\"><tr><td class = \"confirmation-form\">"));
        HtmlTag deletePageYesForm = HtmlUtil.makeFormTag("POST", qualifiedPageName + "?responder=deletePage&confirmed=yes", "deletePageYesForm");
        HtmlTag submitYesButton = HtmlUtil.makeInputTag("submit", "deletePageYesSubmit", "Yes");
        deletePageYesForm.add(submitYesButton);
        divTag.add(deletePageYesForm.html());
        divTag.add(new RawHtml("</td><td class = \"confirmation-form\">"));
        HtmlTag deletePageNoForm = HtmlUtil.makeFormTag("POST", qualifiedPageName, "deletePageNoForm");
        HtmlTag submitNoButton = HtmlUtil.makeInputTag("submit", "deletePageYesSubmit", "No");
        deletePageNoForm.add(submitNoButton);
        divTag.add(deletePageNoForm.html());
        divTag.add(new RawHtml("</tr></table></center>"));
        divTag.add(HtmlUtil.BR);
        return divTag.html();
    }

    private HtmlTag makeHeadingTag(boolean addSubPageWarning, String qualifiedPageName) {
        HtmlTag h3Tag = new HtmlTag("H3");
        if (addSubPageWarning) {
            h3Tag.add("Warning, this page contains one or more subpages.");
            h3Tag.add(HtmlUtil.BR);
        }
        h3Tag.add("Are you sure you want to delete " + qualifiedPageName + "?");
        return h3Tag;
    }

    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

