/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.refactoring;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureResponder;
import fitnesse.components.MovedPageReferenceRenamer;
import fitnesse.components.ReferenceRenamer;
import fitnesse.http.Request;
import fitnesse.responders.refactoring.PageMovementResponder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;

public class MovePageResponder
extends PageMovementResponder
implements SecureResponder {
    private String newParentName;

    protected boolean getAndValidateNewParentPage(FitNesseContext context, Request request) throws Exception {
        PageCrawler crawler = context.root.getPageCrawler();
        this.newParentName = MovePageResponder.getNameofNewParent(request);
        if (this.newParentName == null) {
            return false;
        }
        this.newParentPath = PathParser.parse(this.newParentName);
        this.newParentPage = crawler.getPage(context.root, this.newParentPath);
        return this.newParentPage != null;
    }

    private static String getNameofNewParent(Request request) {
        String newParentName = (String)request.getInput("newLocation");
        if (".".equals(newParentName)) {
            return "";
        }
        return newParentName;
    }

    protected boolean getAndValidateRefactoringParameters(Request request) throws Exception {
        WikiPagePath newParentPath;
        PageCrawler crawler = this.oldRefactoredPage.getPageCrawler();
        WikiPagePath pageToBeMovedPath = crawler.getFullPath(this.oldRefactoredPage);
        return !pageToBeMovedPath.equals(newParentPath = crawler.getFullPath(this.newParentPage)) && !this.selfPage(pageToBeMovedPath, newParentPath) && !this.pageIsAncestorOfNewParent(pageToBeMovedPath, newParentPath);
    }

    private boolean selfPage(WikiPagePath pageToBeMovedPath, WikiPagePath newParentPath) throws Exception {
        WikiPagePath originalParentPath = pageToBeMovedPath.parentPath();
        return originalParentPath.equals(newParentPath);
    }

    boolean pageIsAncestorOfNewParent(WikiPagePath pageToBeMovedPath, WikiPagePath newParentPath) throws Exception {
        return newParentPath.startsWith(pageToBeMovedPath);
    }

    protected ReferenceRenamer getReferenceRenamer(FitNesseContext context) throws Exception {
        return new MovedPageReferenceRenamer(context.root, this.oldRefactoredPage, this.newParentName);
    }

    protected void execute() throws Exception {
        WikiPage newPage = this.newParentPage.addChildPage(this.getNewPageName());
        this.movePage(this.oldRefactoredPage, newPage);
    }

    protected String getNewPageName() throws Exception {
        return this.oldRefactoredPage.getName();
    }

    protected String getErrorMessageHeader() throws Exception {
        return "Cannot move " + this.makeLink(this.oldNameOfPageToBeMoved) + " below " + this.newParentName;
    }
}

