/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.refactoring;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.components.ReferenceRenamer;
import fitnesse.html.HtmlUtil;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.ErrorResponder;
import fitnesse.responders.NotFoundResponder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.List;

public abstract class PageMovementResponder
implements SecureResponder {
    protected String oldNameOfPageToBeMoved;
    protected WikiPage oldRefactoredPage;
    protected WikiPage newParentPage;
    protected WikiPagePath newParentPath;

    protected abstract boolean getAndValidateNewParentPage(FitNesseContext var1, Request var2) throws Exception;

    protected abstract boolean getAndValidateRefactoringParameters(Request var1) throws Exception;

    protected abstract ReferenceRenamer getReferenceRenamer(FitNesseContext var1) throws Exception;

    protected abstract String getNewPageName() throws Exception;

    protected abstract String getErrorMessageHeader() throws Exception;

    protected abstract void execute() throws Exception;

    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        if (!this.getAndValidateRefactoredPage(context, request)) {
            return new NotFoundResponder().makeResponse(context, request);
        }
        if (!this.getAndValidateNewParentPage(context, request)) {
            return this.makeErrorMessageResponder(this.newParentPath == null ? "null" : this.newParentPath.toString() + " does not exist.").makeResponse(context, request);
        }
        if (!this.getAndValidateRefactoringParameters(request)) {
            return this.makeErrorMessageResponder("").makeResponse(context, request);
        }
        if (this.targetPageExists()) {
            return this.makeErrorMessageResponder(this.makeLink(this.getNewPageName()) + " already exists").makeResponse(context, request);
        }
        if (request.hasInput("refactorReferences")) {
            this.getReferenceRenamer(context).renameReferences();
        }
        this.execute();
        SimpleResponse response = new SimpleResponse();
        response.redirect(this.createRedirectionUrl(this.newParentPage, this.getNewPageName()));
        return response;
    }

    protected boolean getAndValidateRefactoredPage(FitNesseContext context, Request request) throws Exception {
        PageCrawler crawler = context.root.getPageCrawler();
        this.oldNameOfPageToBeMoved = request.getResource();
        WikiPagePath path = PathParser.parse(this.oldNameOfPageToBeMoved);
        this.oldRefactoredPage = crawler.getPage(context.root, path);
        return this.oldRefactoredPage != null;
    }

    private Responder makeErrorMessageResponder(String message) throws Exception {
        return new ErrorResponder(this.getErrorMessageHeader() + "<br/>" + message);
    }

    private boolean targetPageExists() throws Exception {
        return this.newParentPage.hasChildPage(this.getNewPageName());
    }

    protected String makeLink(String page) throws Exception {
        return HtmlUtil.makeLink(page, page).html();
    }

    protected String createRedirectionUrl(WikiPage newParent, String newName) throws Exception {
        PageCrawler crawler = newParent.getPageCrawler();
        if (crawler.isRoot(newParent)) {
            return newName;
        }
        return PathParser.render(crawler.getFullPath(newParent).addNameToEnd(newName));
    }

    protected void movePage(WikiPage movedPage, WikiPage targetPage) throws Exception {
        PageData pageData = movedPage.getData();
        targetPage.commit(pageData);
        this.moveChildren(movedPage, targetPage);
        WikiPage parentOfMovedPage = movedPage.getParent();
        parentOfMovedPage.removeChildPage(movedPage.getName());
    }

    protected void moveChildren(WikiPage movedPage, WikiPage newParentPage) throws Exception {
        List<WikiPage> children = movedPage.getChildren();
        for (WikiPage page : children) {
            this.movePage(page, newParentPage.addChildPage(page.getName()));
        }
    }

    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

