/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.refactoring;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.html.TagGroup;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;

public class RefactorPageResponder
implements SecureResponder {
    private String resource;

    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        this.resource = request.getResource();
        SimpleResponse response = new SimpleResponse();
        response.setContent(this.html(context));
        return response;
    }

    public String html(FitNesseContext context) throws Exception {
        HtmlPage html = context.htmlPageFactory.newPage();
        html.title.use("Refactor: " + this.resource);
        html.header.use(HtmlUtil.makeBreadCrumbsWithPageType(this.resource, "Refactor"));
        html.main.use(this.mainContent());
        return html.html();
    }

    private HtmlTag mainContent() throws Exception {
        TagGroup group = new TagGroup();
        group.add(this.deletePageForm());
        group.add(this.renamePageForm());
        group.add(this.movePageForm());
        return group;
    }

    private HtmlTag deletePageForm() throws Exception {
        TagGroup group = new TagGroup();
        group.add(this.makeHeaderTag("Delete:"));
        group.add("Delete this entire sub-wiki.");
        group.add(this.makeDeletePageForm());
        return group;
    }

    private HtmlTag makeHeaderTag(String content) throws Exception {
        return new HtmlTag("h3", content);
    }

    private HtmlTag makeDeletePageForm() throws Exception {
        HtmlTag form = HtmlUtil.makeFormTag("get", this.resource);
        form.add(HtmlUtil.makeInputTag("submit", "", "Delete Page"));
        form.add(HtmlUtil.makeInputTag("hidden", "responder", "deletePage"));
        return form;
    }

    private HtmlTag movePageForm() throws Exception {
        TagGroup group = new TagGroup();
        group.add(HtmlUtil.BR);
        group.add(this.makeHeaderTag("Move:"));
        group.add(this.makeMovePageForm());
        return group;
    }

    private HtmlTag makeMovePageForm() throws Exception {
        HtmlTag form = HtmlUtil.makeFormTag("get", this.resource);
        form.add(HtmlUtil.makeInputTag("hidden", "responder", "movePage"));
        form.add("New Location: ");
        HtmlTag input = HtmlUtil.makeInputTag("text", "newLocation", "");
        input.addAttribute("size", "80");
        form.add(input);
        form.add(HtmlUtil.BR);
        form.add(HtmlUtil.makeInputTag("checkbox", "refactorReferences"));
        form.add(" - Find all references to this page and change them accordingly (May take several minutes)");
        form.add(HtmlUtil.BR);
        form.add(HtmlUtil.makeInputTag("submit", "", "Move Page"));
        return form;
    }

    private HtmlTag renamePageForm() throws Exception {
        TagGroup group = new TagGroup();
        group.add(HtmlUtil.BR);
        group.add(this.makeHeaderTag("Rename:"));
        group.add(this.makeRenamePageForm());
        return group;
    }

    private HtmlTag makeRenamePageForm() throws Exception {
        HtmlTag form = HtmlUtil.makeFormTag("get", this.resource);
        form.add(HtmlUtil.makeInputTag("hidden", "responder", "renamePage"));
        form.add("  New Name: ");
        HtmlTag input = HtmlUtil.makeInputTag("text", "newName", "");
        input.addAttribute("size", "50");
        form.add(input);
        form.add(HtmlUtil.BR);
        form.add(HtmlUtil.makeInputTag("checkbox", "refactorReferences"));
        form.add(" - Find all references to this page and change them accordingly (May take several minutes)");
        form.add(HtmlUtil.BR);
        form.add(HtmlUtil.makeInputTag("submit", "", "Rename Page"));
        return form;
    }

    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

