/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.refactoring;

import fitnesse.FitNesseContext;
import fitnesse.components.PageReferenceRenamer;
import fitnesse.components.ReferenceRenamer;
import fitnesse.http.Request;
import fitnesse.responders.refactoring.PageMovementResponder;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.widgets.WikiWordWidget;

public class RenamePageResponder
extends PageMovementResponder {
    private String newName;

    protected boolean getAndValidateNewParentPage(FitNesseContext context, Request request) throws Exception {
        this.newParentPath = PathParser.parse(this.oldNameOfPageToBeMoved).parentPath();
        this.newParentPage = this.oldRefactoredPage.getParent();
        return this.newParentPage != null;
    }

    protected boolean getAndValidateRefactoringParameters(Request request) throws Exception {
        this.newName = (String)request.getInput("newName");
        return this.newName != null && WikiWordWidget.isSingleWikiWord(this.newName) && !"FrontPage".equals(this.oldNameOfPageToBeMoved);
    }

    protected ReferenceRenamer getReferenceRenamer(FitNesseContext context) throws Exception {
        return new PageReferenceRenamer(context.root, this.oldRefactoredPage, this.getNewPageName());
    }

    protected void execute() throws Exception {
        WikiPage parentOfPageToRename = this.oldRefactoredPage.getParent();
        WikiPage renamedPage = parentOfPageToRename.addChildPage(this.newName);
        this.movePage(this.oldRefactoredPage, renamedPage);
    }

    protected String getNewPageName() throws Exception {
        return this.newName;
    }

    protected String getErrorMessageHeader() throws Exception {
        return "Cannot rename " + this.makeLink(this.oldNameOfPageToBeMoved) + " to " + this.newName;
    }
}

