/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.responders.run.CompositeExecutionLog;
import fitnesse.responders.run.ResultsListener;
import fitnesse.responders.run.TestSummary;
import fitnesse.responders.run.TestSystem;
import fitnesse.responders.run.formatters.BaseFormatter;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFormatter
extends BaseFormatter {
    private String mainPageName;
    private boolean isSuite = true;
    public static final String SUMMARY_FOOTER = "</table>";
    public static final String SUMMARY_HEADER = "<table><tr><td>Name</td><td>Right</td><td>Wrong</td><td>Exceptions</td></tr>";
    private TestSummary totalSummary = new TestSummary();
    private List<String> visitedTestPages = new ArrayList<String>();
    private Map<String, TestSummary> testSummaries = new HashMap<String, TestSummary>();
    private ResultsRepository resultsRepository;
    private static Map<String, JavaFormatter> allocatedInstances = new HashMap<String, JavaFormatter>();
    private ResultsListener listener;

    @Override
    public void writeHead(String pageType) throws Exception {
    }

    public String getFullPath(WikiPage wikiPage) throws Exception {
        return new WikiPagePath(wikiPage).toString();
    }

    @Override
    public void newTestStarted(WikiPage test, long time) throws Exception {
        this.resultsRepository.open(this.getFullPath(test));
        if (this.listener != null) {
            this.listener.newTestStarted(test, time);
        }
    }

    @Override
    public void setExecutionLogAndTrackingId(String stopResponderId, CompositeExecutionLog log) throws Exception {
    }

    @Override
    public void testComplete(WikiPage test, TestSummary testSummary) throws Exception {
        String fullPath = this.getFullPath(test);
        this.visitedTestPages.add(fullPath);
        this.totalSummary.add(testSummary);
        this.testSummaries.put(fullPath, testSummary);
        this.resultsRepository.close();
        boolean bl = this.isSuite = this.isSuite && !this.mainPageName.equals(fullPath);
        if (this.listener != null) {
            this.listener.testComplete(test, testSummary);
        }
    }

    @Override
    public void testOutputChunk(String output) throws Exception {
        this.resultsRepository.write(output);
    }

    @Override
    public void testSystemStarted(TestSystem testSystem, String testSystemName, String testRunner) throws Exception {
    }

    public TestSummary getTotalSummary() {
        return this.totalSummary;
    }

    public void setTotalSummary(TestSummary testSummary) {
        this.totalSummary = testSummary;
    }

    public void setResultsRepository(ResultsRepository mockResultsRepository) {
        this.resultsRepository = mockResultsRepository;
    }

    JavaFormatter(String suiteName) {
        this.mainPageName = suiteName;
    }

    public static synchronized JavaFormatter getInstance(String testName) {
        JavaFormatter existing = allocatedInstances.get(testName);
        if (existing != null) {
            return existing;
        }
        existing = new JavaFormatter(testName);
        allocatedInstances.put(testName, existing);
        return existing;
    }

    @Override
    public void allTestingComplete() throws Exception {
        if (this.isSuite) {
            this.writeSummary(this.mainPageName);
        }
        if (this.listener != null) {
            this.listener.allTestingComplete();
        }
    }

    public void writeSummary(String suiteName) throws IOException {
        this.resultsRepository.open(suiteName);
        this.resultsRepository.write(SUMMARY_HEADER);
        for (String s : this.visitedTestPages) {
            this.resultsRepository.write(this.summaryRow(s, this.testSummaries.get(s)));
        }
        this.resultsRepository.write(SUMMARY_FOOTER);
        this.resultsRepository.close();
    }

    public String summaryRow(String testName, TestSummary testSummary) {
        StringBuffer sb = new StringBuffer();
        sb.append("<tr class=\"").append(this.getCssClass(testSummary)).append("\"><td>").append("<a href=\"").append(testName).append(".html\">").append(testName).append("</a>").append("</td><td>").append(testSummary.right).append("</td><td>").append(testSummary.wrong).append("</td><td>").append(testSummary.exceptions).append("</td></tr>");
        return sb.toString();
    }

    private String getCssClass(TestSummary ts) {
        if (ts.exceptions > 0) {
            return "error";
        }
        if (ts.wrong > 0) {
            return "fail";
        }
        if (ts.right > 0) {
            return "pass";
        }
        return "plain";
    }

    public void setListener(ResultsListener listener) {
        this.listener = listener;
    }

    public List<String> getTestsExecuted() {
        return this.visitedTestPages;
    }

    public static class FolderResultsRepository
    implements ResultsRepository {
        private String outputPath;
        private Writer currentWriter;

        public FolderResultsRepository(String outputPath, String fitNesseRoot) throws IOException {
            this.outputPath = outputPath;
            this.initFolder(fitNesseRoot);
        }

        public void close() throws IOException {
            if (this.currentWriter != null) {
                this.currentWriter.write("</body></html>");
                this.currentWriter.close();
            }
        }

        public void open(String testName) throws IOException {
            this.currentWriter = new FileWriter(new File(this.outputPath, testName + ".html"));
            this.currentWriter.write("<head><title>");
            this.currentWriter.write(testName);
            this.currentWriter.write("</title><link rel='stylesheet' type='text/css' href='fitnesse.css' media='screen'/><link rel='stylesheet' type='text/css' href='fitnesse_print.css' media='print'/><script src='fitnesse.js' type='text/javascript'></script></head><body><h2>");
            this.currentWriter.write(testName);
            this.currentWriter.write("</h2>");
        }

        public void write(String content) throws IOException {
            this.currentWriter.write(content.replace("src=\"/files/images/", "src=\"images/"));
        }

        public void addFile(File f, String relativeFilePath) throws IOException {
            File dst = new File(this.outputPath, relativeFilePath);
            dst.getParentFile().mkdirs();
            this.copy(f, dst);
        }

        private void copy(File src, File dst) throws IOException {
            int len;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }

        private void initFolder(String fitnesseRoot) throws IOException {
            File filesFolder = new File(new File(new File(fitnesseRoot), "FitNesseRoot"), "files");
            File cssDir = new File(filesFolder, "css");
            this.addFile(new File(cssDir, "fitnesse_base.css"), "fitnesse.css");
            File javascriptDir = new File(filesFolder, "javascript");
            this.addFile(new File(javascriptDir, "fitnesse.js"), "fitnesse.js");
            File imagesDir = new File(filesFolder, "images");
            this.addFile(new File(imagesDir, "collapsableOpen.gif"), "images/collapsableOpen.gif");
            this.addFile(new File(imagesDir, "collapsableClosed.gif"), "images/collapsableClosed.gif");
        }
    }

    public static interface ResultsRepository {
        public void open(String var1) throws IOException;

        public void close() throws IOException;

        public void write(String var1) throws IOException;
    }
}

