/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import util.StringUtil;

public class SuiteFilter {
    private final SuiteTagMatcher notMatchTags;
    private final SuiteTagMatcher matchTags;
    private final String startWithTest;
    public static SuiteFilter NO_MATCHING = new SuiteFilter(null, null, null){

        public boolean isMatchingTest(WikiPage testPage) throws Exception {
            return false;
        }
    };
    public static SuiteFilter MATCH_ALL = new SuiteFilter(null, null, null);

    SuiteFilter(String matchingTags, String mustNotMatchTags, String startWithTest) {
        this.startWithTest = !"".equals(startWithTest) ? startWithTest : null;
        this.matchTags = new SuiteTagMatcher(matchingTags, true);
        this.notMatchTags = new SuiteTagMatcher(mustNotMatchTags, false);
    }

    public boolean isMatchingTest(WikiPage testPage) throws Exception {
        PageData data = testPage.getData();
        boolean pruned = data.hasAttribute("Prune");
        boolean isTest = data.hasAttribute("Test");
        return !pruned && isTest && this.matchTags.matches(testPage) && !this.notMatchTags.matches(testPage) && this.afterStartingTest(testPage);
    }

    private boolean afterStartingTest(WikiPage testPage) throws Exception {
        if (this.startWithTest == null) {
            return true;
        }
        PageCrawler crawler = testPage.getPageCrawler();
        WikiPagePath pageName = crawler.getFullPath(testPage);
        return pageName.toString().compareTo(this.startWithTest) >= 0;
    }

    public boolean hasMatchingTests() {
        return this != NO_MATCHING;
    }

    public SuiteFilter getFilterForTestsInSuite(WikiPage suitePage) throws Exception {
        if (suitePage.getData().hasAttribute("Prune")) {
            return NO_MATCHING;
        }
        PageData pageData = suitePage.getData();
        if (pageData.hasAttribute("Suite") && this.matchTags.isFiltering() && this.matchTags.matches(suitePage)) {
            return new SuiteFilter(null, this.notMatchTags.tagString, this.startWithTest).getFilterForTestsInSuite(suitePage);
        }
        if (this.notMatchTags.matches(suitePage)) {
            return NO_MATCHING;
        }
        return this;
    }

    public String toString() {
        LinkedList<String> criterias = new LinkedList<String>();
        if (this.matchTags.isFiltering()) {
            criterias.add("matches '" + this.matchTags.tagString + "'");
        }
        if (this.notMatchTags.isFiltering()) {
            criterias.add("doesn't match '" + this.notMatchTags.tagString + "'");
        }
        if (this.startWithTest != null) {
            criterias.add("starts with test '" + this.startWithTest + "'");
        }
        return StringUtil.join(criterias, " & ");
    }

    private class SuiteTagMatcher {
        private static final String LIST_SEPARATOR = "\\s*,\\s*";
        private final List<String> tags;
        final String tagString;
        private final boolean matchIfNoTags;

        public SuiteTagMatcher(String suiteTags, boolean matchIfNoTags) {
            this.tagString = suiteTags;
            this.tags = suiteTags != null ? new LinkedList<String>(Arrays.asList(suiteTags.split(LIST_SEPARATOR))) : null;
            this.matchIfNoTags = matchIfNoTags;
        }

        boolean isFiltering() {
            return this.tags != null;
        }

        boolean matches(WikiPage wikiPage) {
            return this.tags == null ? this.matchIfNoTags : this.testMatchesQuery(wikiPage);
        }

        private boolean testMatchesQuery(WikiPage wikiPage) {
            String testTagString = this.getTestTags(wikiPage);
            return testTagString != null && this.testTagsMatchQueryTags(testTagString);
        }

        private String getTestTags(WikiPage context) {
            try {
                return context.getData().getAttribute("Suites");
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        private boolean testTagsMatchQueryTags(String testTagString) {
            String[] testTags;
            for (String testTag : testTags = testTagString.trim().split(LIST_SEPARATOR)) {
                for (String queryTag : this.tags) {
                    if (!testTag.equalsIgnoreCase(queryTag)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

