/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.responders.run.MultipleTestsRunner;
import fitnesse.responders.run.SuiteContentsFinder;
import fitnesse.responders.run.SuiteFilter;
import fitnesse.responders.run.TestResponder;
import fitnesse.responders.run.formatters.CachingSuiteXmlFormatter;
import fitnesse.responders.run.formatters.PageHistoryFormatter;
import fitnesse.responders.run.formatters.SuiteHistoryFormatter;
import fitnesse.responders.run.formatters.SuiteHtmlFormatter;

public class SuiteResponder
extends TestResponder {
    String getTitle() {
        return "Suite Results";
    }

    void addXmlFormatter() throws Exception {
        this.formatters.add(new CachingSuiteXmlFormatter(this.context, this.page, this.makeResponseWriter()));
    }

    void addHtmlFormatter() throws Exception {
        SuiteHtmlFormatter formatter = new SuiteHtmlFormatter(this.context, this.page, this.context.htmlPageFactory){

            protected void writeData(String output) throws Exception {
                SuiteResponder.this.addToResponse(output);
            }
        };
        this.formatters.add(formatter);
    }

    protected void addTestHistoryFormatter() throws Exception {
        TestResponder.HistoryWriterFactory source = new TestResponder.HistoryWriterFactory();
        this.formatters.add(new PageHistoryFormatter(this.context, this.page, source));
        this.formatters.add(new SuiteHistoryFormatter(this.context, this.page, source));
    }

    protected void performExecution() throws Exception {
        SuiteFilter filter = new SuiteFilter(this.getSuiteTagFilter(), this.getNotSuiteFilter(), this.getSuiteFirstTest());
        SuiteContentsFinder suiteTestFinder = new SuiteContentsFinder(this.page, filter, this.root);
        MultipleTestsRunner runner = new MultipleTestsRunner(suiteTestFinder.getAllPagesToRunForThisSuite(), this.context, this.page, this.formatters);
        runner.setDebug(this.isRemoteDebug());
        runner.setFastTest(this.isFastTest());
        runner.executeTestPages();
    }

    private String getSuiteTagFilter() {
        return this.request != null ? (String)this.request.getInput("suiteFilter") : null;
    }

    private String getNotSuiteFilter() {
        return this.request != null ? (String)this.request.getInput("excludeSuiteFilter") : null;
    }

    private String getSuiteFirstTest() throws Exception {
        String suiteName;
        String startTest = null;
        if (this.request != null) {
            startTest = (String)this.request.getInput("firstTest");
        }
        if (startTest != null && startTest.indexOf(suiteName = this.page.getPageCrawler().getFullPath(this.page).toString()) != 0) {
            startTest = suiteName + "." + startTest;
        }
        return startTest;
    }
}

