/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.components.SearchObserver;
import fitnesse.components.SuiteSpecificationMatchFinder;
import fitnesse.slimTables.HtmlTableScanner;
import fitnesse.slimTables.Table;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.util.LinkedList;
import org.htmlparser.util.ParserException;

public class SuiteSpecificationRunner
implements SearchObserver {
    public String titleRegEx;
    public String contentRegEx;
    public LinkedList<WikiPage> testPageList = new LinkedList();
    public WikiPage searchRoot;
    private WikiPage root;
    public PageCrawler crawler;

    public SuiteSpecificationRunner(WikiPage root) {
        this.root = root;
        this.searchRoot = root;
        this.titleRegEx = "";
        this.contentRegEx = "";
        this.crawler = root.getPageCrawler();
    }

    public void findPageMatches() throws Exception {
        SuiteSpecificationMatchFinder finder = new SuiteSpecificationMatchFinder(this.titleRegEx, this.contentRegEx, this);
        finder.search(this.searchRoot);
    }

    public boolean getPageListFromPageContent(String pageContent) throws Exception {
        HtmlTableScanner scanner = new HtmlTableScanner(pageContent);
        for (int tableIndex = 0; tableIndex < scanner.getTableCount(); ++tableIndex) {
            Table table = scanner.getTable(tableIndex);
            if (this.getPageListFromTable(table)) continue;
            return false;
        }
        return true;
    }

    private boolean getPageListFromTable(Table table) throws Exception {
        if (!this.getImportantTableInformation(table)) {
            return false;
        }
        this.findPageMatches();
        this.titleRegEx = "";
        this.contentRegEx = "";
        return true;
    }

    public boolean getImportantTableInformation(Table table) throws Exception {
        if (!SuiteSpecificationRunner.isASuiteSpecificationsTable(table)) {
            return false;
        }
        for (int rowIndex = 0; rowIndex < table.getRowCount(); ++rowIndex) {
            this.getImportantRowInformation(table, rowIndex);
        }
        return true;
    }

    private void getImportantRowInformation(Table table, int rowIndex) throws Exception {
        String cellContent = table.getCellContents(0, rowIndex);
        if (this.isPageRootRow(cellContent)) {
            this.getSearchRoot(table, rowIndex);
        }
        if (this.isTitleRegExRow(cellContent)) {
            this.setTitleRegEx(table, rowIndex);
        }
        if (this.isContentRegExRow(cellContent)) {
            this.setContentRegEx(table, rowIndex);
        }
    }

    private boolean isPageRootRow(String cellContent) {
        return cellContent != null && cellContent.equals("Page");
    }

    private void getSearchRoot(Table table, int rowIndex) throws Exception {
        if (table.getCellContents(1, rowIndex) != null) {
            String searchRootPath = table.getCellContents(1, rowIndex);
            this.searchRoot = this.crawler.getPage(this.root, PathParser.parse(searchRootPath));
        }
    }

    private void setContentRegEx(Table table, int rowIndex) {
        if (table.getCellContents(1, rowIndex) != null) {
            this.contentRegEx = table.getCellContents(1, rowIndex);
        }
    }

    private boolean isContentRegExRow(String cellContent) {
        return cellContent != null && cellContent.equals("Content");
    }

    private void setTitleRegEx(Table table, int rowIndex) {
        if (table.getCellContents(1, rowIndex) != null) {
            this.titleRegEx = table.getCellContents(1, rowIndex);
        }
    }

    private boolean isTitleRegExRow(String cellContent) {
        return cellContent != null && cellContent.equals("Title");
    }

    private static boolean tableIsTooSmall(Table table) {
        return table.getRowCount() < 3;
    }

    public static boolean isASuiteSpecificationsTable(Table table) {
        return !SuiteSpecificationRunner.tableIsTooSmall(table) && table.getCellContents(0, 0).equals("Suite");
    }

    public void hit(WikiPage page) throws Exception {
        for (WikiPage hit : this.testPageList) {
            if (hit != page) continue;
            return;
        }
        if (page.getData().hasAttribute("Test")) {
            this.testPageList.add(page);
        }
    }

    public static boolean isASuiteSpecificationsPage(String page) throws ParserException {
        HtmlTableScanner scanner = new HtmlTableScanner(page);
        if (scanner.getTableCount() > 0) {
            Table table = scanner.getTable(0);
            return SuiteSpecificationRunner.isASuiteSpecificationsTable(table);
        }
        return false;
    }
}

