/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.FitNesseContext;
import fitnesse.responders.run.TestSummary;
import fitnesse.responders.run.formatters.XmlFormatter;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.WikiPage;

public class SuiteXmlFormatter
extends XmlFormatter {
    private TestSummary xmlPageCounts = new TestSummary();

    public SuiteXmlFormatter(FitNesseContext context, WikiPage page, XmlFormatter.WriterFactory writerSource) throws Exception {
        super(context, page, writerSource);
    }

    private void addFinalCounts() throws Exception {
        this.testResponse.finalCounts = new TestSummary();
        this.finalSummary.right = this.testResponse.finalCounts.right = this.xmlPageCounts.getRight();
        this.finalSummary.wrong = this.testResponse.finalCounts.wrong = this.xmlPageCounts.getWrong();
        this.finalSummary.ignores = this.testResponse.finalCounts.ignores = this.xmlPageCounts.getIgnores();
        this.finalSummary.exceptions = this.testResponse.finalCounts.exceptions = this.xmlPageCounts.getExceptions();
    }

    public void testComplete(WikiPage testPage, TestSummary testSummary) throws Exception {
        PageCrawler pageCrawler = this.getPage().getPageCrawler();
        String relativeName = pageCrawler.getRelativeName(this.getPage(), testPage);
        if ("".equals(relativeName)) {
            relativeName = String.format("(%s)", testPage.getName());
        }
        this.processTestResults(relativeName, testSummary);
        this.xmlPageCounts.tallyPageCounts(testSummary);
    }

    public void allTestingComplete() throws Exception {
        this.addFinalCounts();
        super.allTestingComplete();
    }
}

