/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.responders.run.ExecutionReport;
import fitnesse.responders.run.TestSummary;
import java.io.File;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.XmlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestExecutionReport
extends ExecutionReport {
    public List<TestResult> results = new ArrayList<TestResult>();

    public TestExecutionReport() {
    }

    public TestExecutionReport(InputStream input) throws Exception {
        this.xmlDoc = XmlUtil.newDocument(input);
        this.unpackXml();
    }

    public TestExecutionReport(String string) throws Exception {
        this.xmlDoc = XmlUtil.newDocument(string);
        this.unpackXml();
    }

    public TestExecutionReport(Document xmlDocument) throws Exception {
        super(xmlDocument);
        this.unpackXml();
    }

    public TestExecutionReport read(File file) throws Exception {
        this.xmlDoc = XmlUtil.newDocument(file);
        this.unpackXml();
        return this;
    }

    @Override
    protected void unpackResults(Element testResults) throws Exception {
        NodeList xmlResults = testResults.getElementsByTagName("result");
        for (int resultIndex = 0; resultIndex < xmlResults.getLength(); ++resultIndex) {
            this.unpackResult(xmlResults, resultIndex);
        }
    }

    private void unpackResult(NodeList xmlResults, int resultIndex) throws Exception {
        Element xmlResult = (Element)xmlResults.item(resultIndex);
        TestResult result = new TestResult();
        this.results.add(result);
        result.content = XmlUtil.getTextValue(xmlResult, "content");
        result.right = XmlUtil.getTextValue(xmlResult, "right");
        result.wrong = XmlUtil.getTextValue(xmlResult, "wrong");
        result.ignores = XmlUtil.getTextValue(xmlResult, "ignores");
        result.exceptions = XmlUtil.getTextValue(xmlResult, "exceptions");
        result.relativePageName = XmlUtil.getTextValue(xmlResult, "relativePageName");
        result.tags = XmlUtil.getTextValue(xmlResult, "tags");
        this.unpackTables(xmlResult, result);
        Element xmlInstructions = XmlUtil.getElementByTagName(xmlResult, "instructions");
        if (xmlInstructions != null) {
            this.unpackInstructions(result, xmlInstructions);
        }
    }

    private void unpackInstructions(TestResult result, Element xmlInstructions) throws Exception {
        NodeList xmlInstructionResults = xmlInstructions.getElementsByTagName("instructionResult");
        for (int instructionIndex = 0; instructionIndex < xmlInstructionResults.getLength(); ++instructionIndex) {
            Element instructionElement = (Element)xmlInstructionResults.item(instructionIndex);
            String instruction = XmlUtil.getTextValue(instructionElement, "instruction");
            String slimResult = XmlUtil.getTextValue(instructionElement, "slimResult");
            InstructionResult instructionResult = new InstructionResult();
            instructionResult.instruction = instruction;
            instructionResult.slimResult = slimResult;
            result.instructions.add(instructionResult);
            this.unpackExpectations(instructionElement, instructionResult);
        }
    }

    private void unpackExpectations(Element instructionElement, InstructionResult instructionResult) throws Exception {
        NodeList xmlExpectations = instructionElement.getElementsByTagName("expectation");
        for (int expectationIndex = 0; expectationIndex < xmlExpectations.getLength(); ++expectationIndex) {
            Element expectationElement = (Element)xmlExpectations.item(expectationIndex);
            Expectation expectation = new Expectation();
            instructionResult.addExpectation(expectation);
            expectation.status = XmlUtil.getTextValue(expectationElement, "status");
            expectation.instructionId = XmlUtil.getTextValue(expectationElement, "instructionId");
            expectation.col = XmlUtil.getTextValue(expectationElement, "col");
            expectation.row = XmlUtil.getTextValue(expectationElement, "row");
            expectation.type = XmlUtil.getTextValue(expectationElement, "type");
            expectation.actual = XmlUtil.getTextValue(expectationElement, "actual");
            expectation.expected = XmlUtil.getTextValue(expectationElement, "expected");
            expectation.evaluationMessage = XmlUtil.getTextValue(expectationElement, "evaluationMessage");
        }
    }

    private void unpackTables(Element xmlResult, TestResult result) throws Exception {
        NodeList tables = xmlResult.getElementsByTagName("tables");
        for (int tableIndex = 0; tableIndex < tables.getLength(); ++tableIndex) {
            Element xmlTable = (Element)tables.item(tableIndex);
            String tableName = XmlUtil.getTextValue(xmlTable, "name");
            Table table = new Table(tableName);
            result.tables.add(table);
            this.unpackTable(xmlTable, table);
        }
    }

    private void unpackTable(Element xmlTable, Table table) throws Exception {
        NodeList xmlRows = xmlTable.getElementsByTagName("row");
        for (int rowIndex = 0; rowIndex < xmlRows.getLength(); ++rowIndex) {
            Element xmlRow = (Element)xmlRows.item(rowIndex);
            this.unpackRow(table, xmlRow);
        }
    }

    private void unpackRow(Table table, Element xmlRow) throws Exception {
        Row row = new Row();
        table.add(row);
        NodeList xmlCols = xmlRow.getElementsByTagName("col");
        for (int colIndex = 0; colIndex < xmlCols.getLength(); ++colIndex) {
            Element xmlCol = (Element)xmlCols.item(colIndex);
            String colText = XmlUtil.getElementText(xmlCol);
            row.add(colText);
        }
    }

    public List<TestResult> getResults() {
        return this.results;
    }

    public void toXml(Writer writer, VelocityEngine velocityEngine) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("response", (Object)this);
        Template template = velocityEngine.getTemplate("testResults.vm");
        template.merge((Context)velocityContext, writer);
    }

    public TestSummary getAssertionCounts() {
        TestSummary assertionCounts = new TestSummary();
        for (TestResult result : this.results) {
            assertionCounts.add(result.getTestSummary());
        }
        return assertionCounts;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Row
    extends ArrayList<String> {
        private static final long serialVersionUID = 1L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Table
    extends ArrayList<Row> {
        private static final long serialVersionUID = 1L;
        private String name;

        public Table(String tableName) {
            this.name = tableName;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Expectation {
        public String instructionId;
        public String col;
        public String row;
        public String type;
        public String actual;
        public String expected;
        public String evaluationMessage;
        public String status;

        public String getInstructionId() {
            return this.instructionId;
        }

        public String getCol() {
            return this.col;
        }

        public String getRow() {
            return this.row;
        }

        public String getType() {
            return this.type;
        }

        public String getActual() {
            return this.actual;
        }

        public String getExpected() {
            return this.expected;
        }

        public String getEvaluationMessage() {
            return this.evaluationMessage;
        }

        public String getStatus() {
            return this.status;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InstructionResult {
        public String instruction;
        public String slimResult;
        private List<Expectation> expectations = new ArrayList<Expectation>();

        public void addExpectation(Expectation expectation) {
            this.expectations.add(expectation);
        }

        public String getInstruction() {
            return this.instruction;
        }

        public String getSlimResult() {
            return this.slimResult;
        }

        public List<Expectation> getExpectations() {
            return this.expectations;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestResult {
        public String right;
        public String wrong;
        public String ignores;
        public String exceptions;
        public String content;
        public String relativePageName;
        public List<InstructionResult> instructions = new ArrayList<InstructionResult>();
        public String tags;
        public List<Table> tables = new ArrayList<Table>();
        public long startTime;

        public String getRight() {
            return this.right;
        }

        public String getWrong() {
            return this.wrong;
        }

        public String getIgnores() {
            return this.ignores;
        }

        public String getExceptions() {
            return this.exceptions;
        }

        public String getContent() {
            return this.content;
        }

        public String getRelativePageName() {
            return this.relativePageName;
        }

        public List<InstructionResult> getInstructions() {
            return this.instructions;
        }

        public String getTags() {
            return this.tags;
        }

        public void setTags(String tags) {
            this.tags = tags;
        }

        public List<Table> getTables() {
            return this.tables;
        }

        public TestSummary getTestSummary() {
            return new TestSummary(Integer.parseInt(this.right), Integer.parseInt(this.wrong), Integer.parseInt(this.ignores), Integer.parseInt(this.exceptions));
        }
    }
}

