/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fit.Counts;
import fit.FitProtocol;
import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.http.InputStreamResponse;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.responders.run.TestSummary;
import fitnesse.runner.HtmlResultFormatter;
import fitnesse.runner.MockResultFormatter;
import fitnesse.runner.PageResult;
import fitnesse.runner.ResultFormatter;
import fitnesse.runner.XmlResultFormatter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import util.StreamReader;

public class TestResultFormattingResponder
implements Responder {
    public ResultFormatter formatter = new MockResultFormatter();
    public Counts finalCounts;
    private FitNesseContext context;
    private String baseUrl;
    private String rootPath;

    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        this.init(context, request);
        String results = (String)request.getInput("results");
        byte[] bytes = results.getBytes("UTF-8");
        this.processResults(new ByteArrayInputStream(bytes));
        InputStreamResponse response = new InputStreamResponse();
        response.setBody(this.formatter.getResultStream(), this.formatter.getByteCount());
        return response;
    }

    public void init(FitNesseContext context, Request request) throws Exception {
        this.context = context;
        this.baseUrl = (String)request.getHeader("Host");
        this.rootPath = request.getResource();
        this.formatter = this.makeFormatter(request);
    }

    public void processResults(InputStream input) throws Exception {
        StreamReader reader = new StreamReader(input);
        boolean readingResults = true;
        while (readingResults) {
            int bytesToRead = FitProtocol.readSize(reader);
            if (bytesToRead != 0) {
                String resultString = reader.read(bytesToRead);
                PageResult result = PageResult.parse(resultString);
                this.formatter.acceptResult(result);
                continue;
            }
            readingResults = false;
        }
        Counts counts = FitProtocol.readCounts(reader);
        TestSummary testSummary = new TestSummary(counts.right, counts.wrong, counts.ignores, counts.exceptions);
        this.formatter.acceptFinalCount(testSummary);
    }

    public ResultFormatter makeFormatter(Request request) throws Exception {
        String format = (String)request.getInput("format");
        if (format != null) {
            if ("html".equals(format)) {
                return new HtmlResultFormatter(this.context, this.baseUrl, this.rootPath);
            }
            if ("xml".equals(format)) {
                return new XmlResultFormatter(this.baseUrl, this.rootPath);
            }
        }
        return new MockResultFormatter();
    }
}

