/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

public class TestSummary {
    public int right = 0;
    public int wrong = 0;
    public int ignores = 0;
    public int exceptions = 0;

    public TestSummary(int right, int wrong, int ignores, int exceptions) {
        this.right = right;
        this.wrong = wrong;
        this.ignores = ignores;
        this.exceptions = exceptions;
    }

    public TestSummary(TestSummary testSummary) {
        this.right = testSummary.getRight();
        this.wrong = testSummary.getWrong();
        this.ignores = testSummary.getIgnores();
        this.exceptions = testSummary.getExceptions();
    }

    public TestSummary() {
    }

    public String toString() {
        return this.getRight() + " right, " + this.getWrong() + " wrong, " + this.getIgnores() + " ignored, " + this.getExceptions() + " exceptions";
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TestSummary)) {
            return false;
        }
        TestSummary other = (TestSummary)o;
        return this.getRight() == other.getRight() && this.getWrong() == other.getWrong() && this.getIgnores() == other.getIgnores() && this.getExceptions() == other.getExceptions();
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public void tallyPageCounts(TestSummary counts) {
        if (counts.getWrong() > 0) {
            this.wrong = this.getWrong() + 1;
        } else if (counts.getExceptions() > 0) {
            this.exceptions = this.getExceptions() + 1;
        } else if (counts.getRight() == 0) {
            this.ignores = this.getIgnores() + 1;
        } else {
            this.right = this.getRight() + 1;
        }
    }

    public void add(TestSummary testSummary) {
        this.right = this.getRight() + testSummary.getRight();
        this.wrong = this.getWrong() + testSummary.getWrong();
        this.ignores = this.getIgnores() + testSummary.getIgnores();
        this.exceptions = this.getExceptions() + testSummary.getExceptions();
    }

    public void clear() {
        this.right = 0;
        this.wrong = 0;
        this.ignores = 0;
        this.exceptions = 0;
    }

    public int getRight() {
        return this.right;
    }

    public int getWrong() {
        return this.wrong;
    }

    public int getIgnores() {
        return this.ignores;
    }

    public int getExceptions() {
        return this.exceptions;
    }
}

