/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.formatters;

import fitnesse.FitNesseContext;
import fitnesse.VelocityFactory;
import fitnesse.responders.run.SuiteExecutionReport;
import fitnesse.responders.run.TestExecutionReport;
import fitnesse.responders.run.formatters.SuiteExecutionReportFormatter;
import fitnesse.responders.testHistory.PageHistory;
import fitnesse.responders.testHistory.TestHistory;
import fitnesse.wiki.WikiPage;
import java.io.Writer;
import java.util.Date;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class CachingSuiteXmlFormatter
extends SuiteExecutionReportFormatter {
    private TestHistory testHistory = new TestHistory();
    private VelocityContext velocityContext = new VelocityContext();
    private VelocityEngine velocityEngine = VelocityFactory.getVelocityEngine();
    private Writer writer;

    public CachingSuiteXmlFormatter(FitNesseContext context, WikiPage page, Writer writer) throws Exception {
        super(context, page);
        this.writer = writer;
    }

    void setTestHistoryForTests(TestHistory testHistory) {
        this.testHistory = testHistory;
    }

    void setVelocityForTests(VelocityContext velocityContext, VelocityEngine engine, Writer writer) {
        this.velocityContext = velocityContext;
        this.velocityEngine = engine;
        this.writer = writer;
    }

    public void allTestingComplete() throws Exception {
        this.testHistory.readHistoryDirectory(this.context.getTestHistoryDirectory());
        this.velocityContext.put("formatter", (Object)this);
        Template template = this.velocityEngine.getTemplate("suiteXML.vm");
        template.merge((Context)this.velocityContext, this.writer);
        this.writer.close();
    }

    public TestExecutionReport getTestExecutionReport(SuiteExecutionReport.PageHistoryReference reference) throws Exception {
        Date date;
        PageHistory pageHistory = this.testHistory.getPageHistory(reference.getPageName());
        PageHistory.TestResultRecord record = pageHistory.get(date = new Date(reference.getTime()));
        if (record == null) {
            throw new RuntimeException("Did you forget to call XmlFormatter.clearTestTime?");
        }
        return this.makeTestExecutionReport().read(record.getFile());
    }

    TestExecutionReport makeTestExecutionReport() {
        return new TestExecutionReport();
    }
}

