/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.formatters;

import fitnesse.FitNesseContext;
import fitnesse.FitNesseVersion;
import fitnesse.responders.run.CompositeExecutionLog;
import fitnesse.responders.run.SuiteExecutionReport;
import fitnesse.responders.run.TestSummary;
import fitnesse.responders.run.TestSystem;
import fitnesse.responders.run.formatters.BaseFormatter;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuiteExecutionReportFormatter
extends BaseFormatter {
    private SuiteExecutionReport.PageHistoryReference referenceToCurrentTest;
    protected SuiteExecutionReport suiteExecutionReport = new SuiteExecutionReport();

    public SuiteExecutionReportFormatter(FitNesseContext context, WikiPage page) throws Exception {
        super(context, page);
        this.suiteExecutionReport.version = new FitNesseVersion().toString();
        this.suiteExecutionReport.rootPath = this.page.getName();
    }

    @Override
    public void writeHead(String pageType) throws Exception {
    }

    @Override
    public void setExecutionLogAndTrackingId(String stopResponderId, CompositeExecutionLog log) throws Exception {
    }

    @Override
    public void testSystemStarted(TestSystem testSystem, String testSystemName, String testRunner) throws Exception {
    }

    @Override
    public void newTestStarted(WikiPage test, long time) throws Exception {
        String pageName = PathParser.render(test.getPageCrawler().getFullPath(test));
        this.referenceToCurrentTest = new SuiteExecutionReport.PageHistoryReference(pageName, time);
    }

    @Override
    public void testOutputChunk(String output) throws Exception {
    }

    public String getRootPageName() {
        return this.suiteExecutionReport.getRootPath();
    }

    @Override
    public void testComplete(WikiPage test, TestSummary testSummary) throws Exception {
        this.referenceToCurrentTest.setTestSummary(testSummary);
        this.suiteExecutionReport.addPageHistoryReference(this.referenceToCurrentTest);
        this.suiteExecutionReport.tallyPageCounts(testSummary);
    }

    public List<SuiteExecutionReport.PageHistoryReference> getPageHistoryReferences() {
        return this.suiteExecutionReport.getPageHistoryReferences();
    }

    @Override
    public int getErrorCount() {
        return this.getPageCounts().wrong + this.getPageCounts().exceptions;
    }

    public TestSummary getPageCounts() {
        return this.suiteExecutionReport.getFinalCounts();
    }
}

