/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.formatters;

import fitnesse.FitNesseContext;
import fitnesse.VelocityFactory;
import fitnesse.responders.run.formatters.BaseFormatter;
import fitnesse.responders.run.formatters.SuiteExecutionReportFormatter;
import fitnesse.responders.run.formatters.XmlFormatter;
import fitnesse.wiki.WikiPage;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class SuiteHistoryFormatter
extends SuiteExecutionReportFormatter {
    private Writer writer;
    private XmlFormatter.WriterFactory writerFactory;
    private long suiteTime = 0L;

    public SuiteHistoryFormatter(FitNesseContext context, WikiPage page, Writer writer) throws Exception {
        super(context, page);
        this.writer = writer;
    }

    public void newTestStarted(WikiPage test, long time) throws Exception {
        if (this.suiteTime == 0L) {
            this.suiteTime = time;
        }
        super.newTestStarted(test, time);
    }

    public SuiteHistoryFormatter(FitNesseContext context, WikiPage page, XmlFormatter.WriterFactory source) throws Exception {
        super(context, page);
        this.writerFactory = source;
    }

    public void allTestingComplete() throws Exception {
        if (this.writerFactory != null) {
            this.writer = this.writerFactory.getWriter(this.context, this.page, this.getPageCounts(), this.getSuiteTime());
        }
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("suiteExecutionReport", (Object)this.suiteExecutionReport);
        VelocityEngine velocityEngine = VelocityFactory.getVelocityEngine();
        Template template = velocityEngine.getTemplate("suiteHistoryXML.vm");
        template.merge((Context)velocityContext, this.writer);
        this.writer.close();
    }

    private long getSuiteTime() {
        if (BaseFormatter.testTime != 0L) {
            return BaseFormatter.testTime;
        }
        return this.suiteTime;
    }
}

