/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.formatters;

import fitnesse.FitNesseContext;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlPageFactory;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.html.RawHtml;
import fitnesse.html.TagGroup;
import fitnesse.responders.WikiImportProperty;
import fitnesse.responders.run.CompositeExecutionLog;
import fitnesse.responders.run.TestSummary;
import fitnesse.responders.run.TestSystem;
import fitnesse.responders.run.formatters.BaseFormatter;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;

public abstract class TestHtmlFormatter
extends BaseFormatter {
    private HtmlPageFactory pageFactory;
    private TestSummary assertionCounts = new TestSummary();
    private CompositeExecutionLog log = null;
    private HtmlPage htmlPage = null;
    private boolean wasInterupted = false;
    private static String TESTING_INTERUPTED = "<strong>Testing was interupted and results are incomplete.</strong><br/>";

    public TestHtmlFormatter(FitNesseContext context, WikiPage page, HtmlPageFactory pageFactory) throws Exception {
        super(context, page);
        this.pageFactory = pageFactory;
    }

    public TestHtmlFormatter(FitNesseContext context) {
        super(context, null);
    }

    protected abstract void writeData(String var1) throws Exception;

    public void writeHead(String pageType) throws Exception {
        this.htmlPage = this.buildHtml(pageType);
        this.htmlPage.main.use("<!--BREAKPOINT-->");
        this.htmlPage.divide();
        this.writeData(this.htmlPage.preDivision + this.makeSummaryPlaceHolder().html());
    }

    private HtmlTag makeSummaryPlaceHolder() {
        HtmlTag testSummaryDiv = new HtmlTag("div", "Running Tests ...");
        testSummaryDiv.addAttribute("id", "test-summary");
        return testSummaryDiv;
    }

    protected void updateSummaryDiv(String html) throws Exception {
        this.writeData(HtmlUtil.makeReplaceElementScript("test-summary", html).html());
    }

    protected String testPageSummary() {
        return "";
    }

    public void newTestStarted(WikiPage test, long time) throws Exception {
        this.writeData(this.getPage().getData().getHeaderPageHtml());
    }

    public void testSystemStarted(TestSystem testSystem, String testSystemName, String testRunner) throws Exception {
    }

    public void testOutputChunk(String output) throws Exception {
        this.writeData(output);
    }

    public void testComplete(WikiPage test, TestSummary testSummary) throws Exception {
        this.getAssertionCounts().add(testSummary);
    }

    public void setExecutionLogAndTrackingId(String stopResponderId, CompositeExecutionLog log) throws Exception {
        this.log = log;
        this.addStopLink(stopResponderId);
    }

    private void addStopLink(String stopResponderId) throws Exception {
        String link = "?responder=stoptest&id=" + stopResponderId;
        HtmlTag status = new HtmlTag("div");
        status.addAttribute("id", "stop-test");
        HtmlTag image = new HtmlTag("img");
        image.addAttribute("src", "/files/images/stop.gif");
        status.add(HtmlUtil.makeSilentLink(link, image));
        status.add(HtmlUtil.BR);
        status.add(HtmlUtil.makeSilentLink(link, new RawHtml("Stop Test")));
        this.writeData(status.html());
    }

    private void removeStopTestLink() throws Exception {
        HtmlTag script = HtmlUtil.makeReplaceElementScript("stop-test", "");
        this.writeData(script.html());
    }

    protected HtmlPage buildHtml(String pageType) throws Exception {
        PageCrawler pageCrawler = this.getPage().getPageCrawler();
        WikiPagePath fullPath = pageCrawler.getFullPath(this.getPage());
        String fullPathName = PathParser.render(fullPath);
        HtmlPage html = this.pageFactory.newPage();
        html.title.use(pageType + ": " + fullPathName);
        html.header.use(HtmlUtil.makeBreadCrumbsWithPageType(fullPathName, pageType));
        html.header.add(String.format("&nbsp;<a style=\"font-size:small;\" href=\"%s?pageHistory\"> [history]</a>", fullPathName));
        PageData data = this.getPage().getData();
        html.actions.use(HtmlUtil.makeActions(this.getPage().getActions()));
        WikiImportProperty.handleImportProperties(html, this.getPage(), data);
        return html;
    }

    public void allTestingComplete() throws Exception {
        this.removeStopTestLink();
        this.publishAndAddLog();
        this.finishWritingOutput();
        this.close();
    }

    protected void close() throws Exception {
    }

    protected void finishWritingOutput() throws Exception {
        this.writeData(this.getPage().getData().getFooterPageHtml());
        this.writeData(this.htmlPage.postDivision);
    }

    protected void publishAndAddLog() throws Exception {
        this.writeData(this.testSummary());
        if (this.log != null) {
            this.log.publish();
            this.writeData(this.executionStatus(this.log));
        }
    }

    protected String cssClassFor(TestSummary testSummary) {
        if (testSummary.getWrong() > 0 || this.wasInterupted) {
            return "fail";
        }
        if (testSummary.getExceptions() > 0 || testSummary.getRight() + testSummary.getIgnores() == 0) {
            return "error";
        }
        if (testSummary.getIgnores() > 0 && testSummary.getRight() == 0) {
            return "ignore";
        }
        return "pass";
    }

    public String executionStatus(CompositeExecutionLog logs) throws Exception {
        return logs.executionStatusHtml();
    }

    protected String makeSummaryContent() {
        String summaryContent = this.testPageSummary();
        summaryContent = summaryContent + "<strong>Assertions:</strong> " + this.assertionCounts.toString();
        return summaryContent;
    }

    public String testSummary() throws Exception {
        String summaryContent = this.wasInterupted ? TESTING_INTERUPTED : "";
        summaryContent = summaryContent + this.makeSummaryContent();
        HtmlTag script = HtmlUtil.makeReplaceElementScript("test-summary", summaryContent);
        script.add("document.getElementById(\"test-summary\").className = \"" + this.cssClassFor(this.assertionCounts) + "\";");
        return script.html();
    }

    public int getErrorCount() {
        return this.getAssertionCounts().getWrong() + this.getAssertionCounts().getExceptions();
    }

    public void addMessageForBlankHtml() throws Exception {
        TagGroup html = new TagGroup();
        HtmlTag h2 = new HtmlTag("h2");
        h2.addAttribute("class", "centered");
        h2.add("Oops!  Did you forget to add to some content to this ?");
        html.add(h2.html());
        html.add(HtmlUtil.HR.html());
        this.writeData(html.html());
    }

    public TestSummary getAssertionCounts() {
        return this.assertionCounts;
    }

    public HtmlPage getHtmlPage() throws Exception {
        if (this.htmlPage != null) {
            return this.htmlPage;
        }
        return this.buildHtml("");
    }

    public void errorOccured() {
        this.wasInterupted = true;
        super.errorOccured();
    }
}

