/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.formatters;

import fitnesse.http.ChunkedResponse;
import fitnesse.responders.run.CompositeExecutionLog;
import fitnesse.responders.run.TestSummary;
import fitnesse.responders.run.TestSystem;
import fitnesse.responders.run.formatters.BaseFormatter;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.text.SimpleDateFormat;

public class TestTextFormatter
extends BaseFormatter {
    public static int finalErrorCount = 0;
    private ChunkedResponse response;
    private int testCount = 0;
    private int failCount = 0;
    private String timeString;

    public TestTextFormatter(ChunkedResponse response) {
        this.response = response;
    }

    public void writeHead(String pageType) throws Exception {
    }

    public void setExecutionLogAndTrackingId(String stopResponderId, CompositeExecutionLog log) throws Exception {
    }

    public void testSystemStarted(TestSystem testSystem, String testSystemName, String testRunner) throws Exception {
        this.response.add(String.format("\nStarting Test System: %s using %s.\n", testSystemName, testRunner));
    }

    public void newTestStarted(WikiPage page, long time) throws Exception {
        this.timeString = new SimpleDateFormat("HH:mm:ss").format(time);
    }

    private String getPath(WikiPage page) throws Exception {
        return PathParser.render(page.getPageCrawler().getFullPath(page));
    }

    public void testOutputChunk(String output) throws Exception {
    }

    public void testComplete(WikiPage page, TestSummary summary) throws Exception {
        this.response.add(String.format("%s %s R:%-4d W:%-4d I:%-4d E:%-4d %s\t(%s)\n", this.passFail(summary), this.timeString, summary.right, summary.wrong, summary.ignores, summary.exceptions, page.getName(), this.getPath(page)));
    }

    private String passFail(TestSummary summary) {
        ++this.testCount;
        if (summary.wrong > 0) {
            ++this.failCount;
            return "F";
        }
        if (summary.exceptions > 0) {
            ++this.failCount;
            return "X";
        }
        return ".";
    }

    public void allTestingComplete() throws Exception {
        this.response.add(String.format("--------\n%d Tests,\t%d Failures.\n", this.testCount, this.failCount));
        finalErrorCount = this.failCount;
    }
}

