/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.slimResponder;

import fitnesse.html.HtmlUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class ExceptionList {
    private boolean stopTestCalled = false;
    private Map<String, String> exceptions = new HashMap<String, String>();
    private boolean firstHtmlRequest = true;
    private int testNumber = 0;
    private StringBuffer buffer;

    public void addException(String key, String exceptionStack) {
        this.exceptions.put(key, exceptionStack);
    }

    public String toHtml() {
        this.buffer = new StringBuffer();
        if (this.exceptions.size() == 0) {
            return "";
        }
        if (this.firstHtmlRequest) {
            this.firstHtmlRequest = false;
            return this.writeExceptionDiv();
        }
        return this.writeUpdateExceptionDivHtml();
    }

    public boolean stopTestCalled() {
        return this.stopTestCalled;
    }

    public void setStopTestCalled() {
        this.stopTestCalled = true;
    }

    public void resetForNewTest() {
        this.stopTestCalled = false;
        this.firstHtmlRequest = true;
        ++this.testNumber;
    }

    private String writeExceptionDiv() {
        this.header();
        this.writeExceptions();
        this.footer();
        return this.buffer.toString();
    }

    private String writeUpdateExceptionDivHtml() {
        this.writeExceptions();
        return HtmlUtil.makeAppendElementScript(this.getDivName(), this.buffer.toString()).html();
    }

    private void footer() {
        this.buffer.append("</div><hr/>");
    }

    private void writeExceptions() {
        for (String key : this.exceptions.keySet()) {
            this.buffer.append(String.format("<a name=\"%s\"/><b></b>", key));
            String collapsibleSectionFormat = "<div class=\"collapse_rim\"><div style=\"float: right;\" class=\"meta\"><a href=\"javascript:expandAll();\">Expand All</a> | <a href=\"javascript:collapseAll();\">Collapse All</a></div><a href=\"javascript:toggleCollapsable('%d');\"><img src=\"/files/images/collapsableClosed.gif\" class=\"left\" id=\"img%d\"/></a>&nbsp;<span class=\"meta\">%s </span>\n\n\t<div class=\"hidden\" id=\"%d\"><pre>%s</pre></div>\n</div>";
            long id = new Random().nextLong();
            this.buffer.append(String.format(collapsibleSectionFormat, id, id, key, id, this.exceptions.get(key)));
        }
        this.exceptions.clear();
    }

    private void header() {
        this.buffer.append("<div id=\"" + this.getDivName() + "\"><H3> <span class=\"fail\">Exceptions</span></H3><br/>");
    }

    private String getDivName() {
        return "test_exceptions" + this.testNumber;
    }
}

