/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.search;

import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.components.AttributeWikiPageFinder;
import fitnesse.http.Request;
import fitnesse.responders.search.ResultResponder;
import fitnesse.responders.search.SearchFormResponder;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteSearchPropertiesResponder
extends ResultResponder {
    public static final String IGNORED = "Any";
    public static final String ACTION = "Action";
    public static final String SECURITY = "Security";
    public static final String SPECIAL = "Special";

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }

    protected List<PageType> getPageTypesFromInput(Request request) {
        String requestedPageTypes = (String)request.getInput("PageType");
        if (requestedPageTypes == null) {
            return null;
        }
        ArrayList<PageType> types = new ArrayList<PageType>();
        for (String type : requestedPageTypes.split(",")) {
            types.add(PageType.fromString(type));
        }
        return types;
    }

    protected String getSuitesFromInput(Request request) {
        if (!this.isSuitesGiven(request)) {
            return null;
        }
        return (String)request.getInput("Suites");
    }

    private boolean isSuitesGiven(Request request) {
        return request.hasInput("Suites");
    }

    protected Map<String, Boolean> getAttributesFromInput(Request request) {
        LinkedHashMap<String, Boolean> attributes = new LinkedHashMap<String, Boolean>();
        this.getListboxAttributesFromRequest(request, ACTION, SearchFormResponder.SEARCH_ACTION_ATTRIBUTES, attributes);
        this.getListboxAttributesFromRequest(request, SECURITY, PageData.SECURITY_ATTRIBUTES, attributes);
        this.getListboxAttributesFromRequest(request, SPECIAL, SearchFormResponder.SPECIAL_ATTRIBUTES, attributes);
        Boolean obsoleteFlag = (Boolean)attributes.remove("obsolete");
        if (obsoleteFlag != null) {
            attributes.put("Prune", obsoleteFlag);
        }
        return attributes;
    }

    private void getListboxAttributesFromRequest(Request request, String inputAttributeName, String[] attributeList, Map<String, Boolean> attributes) {
        String requested = (String)request.getInput(inputAttributeName);
        if (requested == null) {
            requested = "";
        }
        if (!IGNORED.equals(requested)) {
            for (String searchAttribute : attributeList) {
                attributes.put(searchAttribute, requested.contains(searchAttribute));
            }
        }
    }

    @Override
    protected String getPageFooterInfo(int hits) throws Exception {
        return "Found " + hits + " results for your search.";
    }

    @Override
    protected String getTitle() throws Exception {
        return "Search Page Properties Results";
    }

    @Override
    protected void startSearching() throws Exception {
        super.startSearching();
        List<PageType> pageTypes = this.getPageTypesFromInput(this.request);
        Map<String, Boolean> attributes = this.getAttributesFromInput(this.request);
        String suites = this.getSuitesFromInput(this.request);
        if (pageTypes == null && attributes.isEmpty() && suites == null) {
            this.response.add("No search properties were specified.");
            return;
        }
        AttributeWikiPageFinder finder = new AttributeWikiPageFinder(this, pageTypes, attributes, suites);
        finder.search(this.page);
    }
}

