/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.search;

import fitnesse.VelocityFactory;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.components.SearchObserver;
import fitnesse.responders.ChunkingResponder;
import fitnesse.responders.templateUtilities.PageTitle;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public abstract class ResultResponder
extends ChunkingResponder
implements SearchObserver,
SecureResponder {
    private int hits;
    private int nextRow = 0;

    protected PageCrawler getPageCrawler() {
        return this.root.getPageCrawler();
    }

    protected void doSending() throws Exception {
        this.response.add(this.createSearchResultsHeader());
        this.startSearching();
        this.response.add(this.createSearchResultsFooter());
        this.response.closeAll();
    }

    private String createSearchResultsFooter() throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        StringWriter writer = new StringWriter();
        Template template = VelocityFactory.getVelocityEngine().getTemplate("searchResultsFooter.vm");
        if (this.page == null) {
            this.page = this.context.root.getPageCrawler().getPage(this.context.root, PathParser.parse("FrontPage"));
        }
        velocityContext.put("hits", (Object)this.hits);
        if (this.request.getQueryString() == null || this.request.getQueryString().equals("")) {
            velocityContext.put("request", (Object)this.request.getBody());
        } else {
            velocityContext.put("request", (Object)this.request.getQueryString());
        }
        velocityContext.put("page", (Object)this.page);
        template.merge((Context)velocityContext, (Writer)writer);
        return writer.toString();
    }

    private String createSearchResultsHeader() throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        StringWriter writer = new StringWriter();
        Template template = VelocityFactory.getVelocityEngine().getTemplate("searchResultsHeader.vm");
        velocityContext.put("page_title", (Object)this.getTitle());
        velocityContext.put("pageTitle", (Object)new PageTitle(this.getTitle()){

            public String getTitle() {
                return "search";
            }

            public String getLink() {
                return "search";
            }
        });
        template.merge((Context)velocityContext, (Writer)writer);
        return writer.toString();
    }

    public static String getDateFormatJavascriptRegex() {
        return "/^(\\w+) (jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec) (\\d+) (\\d+).(\\d+).(\\d+) (\\w+) (\\d+)$/";
    }

    public void hit(WikiPage page) throws Exception {
        ++this.hits;
        this.response.add(this.createSearchResultsEntry(page));
    }

    private String createSearchResultsEntry(WikiPage result) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        StringWriter writer = new StringWriter();
        Template template = VelocityFactory.getVelocityEngine().getTemplate("searchResultsEntry.vm");
        velocityContext.put("resultsRow", (Object)this.getRow());
        velocityContext.put("result", (Object)result);
        template.merge((Context)velocityContext, (Writer)writer);
        return writer.toString();
    }

    private int getRow() {
        return this.nextRow++ % 2 + 1;
    }

    protected abstract String getTitle() throws Exception;

    protected abstract String getPageFooterInfo(int var1) throws Exception;

    protected void startSearching() throws Exception {
        this.hits = 0;
    }

    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

