/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.search;

import fitnesse.components.ContentWikiPageFinder;
import fitnesse.components.TitleWikiPageFinder;
import fitnesse.responders.search.ResultResponder;

public class SearchResponder
extends ResultResponder {
    private String getSearchString() {
        return (String)this.request.getInput("searchString");
    }

    private String getSearchType() {
        String searchType = (String)this.request.getInput("searchType");
        if ((searchType = searchType.toLowerCase()).indexOf("title") != -1) {
            return "Title";
        }
        return "Content";
    }

    protected String getPageFooterInfo(int hits) throws Exception {
        return "Found " + hits + " results for your search.";
    }

    protected String getTitle() throws Exception {
        return this.getSearchType() + " Search Results for '" + this.getSearchString() + "'";
    }

    protected void startSearching() throws Exception {
        super.startSearching();
        String searchString = this.getSearchString();
        if (!"".equals(searchString)) {
            String searchType = this.getSearchType();
            if ("Title".equals(searchType)) {
                new TitleWikiPageFinder(searchString, this).search(this.root);
            } else {
                new ContentWikiPageFinder(searchString, this).search(this.root);
            }
        }
    }

    protected boolean shouldRespondWith404() {
        return false;
    }
}

