/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.templateUtilities;

import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPagePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageTitle {
    private String title;
    private String link;
    private List<BreadCrumb> breadCrumbs = new ArrayList<BreadCrumb>();
    private String pageType;

    public PageTitle(WikiPagePath pagePath) {
        List<String> names = pagePath.getNames();
        this.title = names.get(names.size() - 1);
        this.link = PathParser.render(pagePath);
        pagePath.removeNameFromEnd();
        while (pagePath.getNames().size() > 0) {
            names = pagePath.getNames();
            BreadCrumb crumb = new BreadCrumb(names.get(names.size() - 1), PathParser.render(pagePath));
            this.breadCrumbs.add(crumb);
            pagePath.removeNameFromEnd();
        }
        Collections.reverse(this.breadCrumbs);
    }

    public PageTitle() {
    }

    public PageTitle(String pageType) {
        this.setPageType(pageType);
        this.title = pageType;
    }

    public PageTitle(String pageType, WikiPagePath wikiPagePath) {
        this(wikiPagePath);
        this.setPageType(pageType);
    }

    public String getTitle() {
        return this.title;
    }

    public String getLink() {
        return this.link;
    }

    public List<BreadCrumb> getBreadCrumbs() {
        return this.breadCrumbs;
    }

    public String getPageType() {
        return this.pageType;
    }

    public void setPageType(String pageType) {
        this.pageType = pageType;
    }

    public class BreadCrumb {
        private String name;
        private String link;

        public BreadCrumb(String name, String link) {
            this.name = name;
            this.link = link;
        }

        public String getName() {
            return this.name;
        }

        public String getLink() {
            return this.link;
        }
    }
}

