/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.testHistory;

import fitnesse.responders.run.TestExecutionReport;
import fitnesse.responders.testHistory.TableListComparer;
import fitnesse.slimTables.HtmlTableScanner;
import java.io.File;
import java.util.ArrayList;
import org.htmlparser.util.ParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryComparer {
    public static final double MIN_MATCH_SCORE = 0.8;
    public static final double MAX_MATCH_SCORE = 1.2;
    private TableListComparer comparer;
    public String secondFileContent = "";
    public String firstFileContent = "";
    public File resultFile;
    public static ArrayList<String> resultContent;
    public HtmlTableScanner firstScanner;
    public HtmlTableScanner secondScanner;
    public ArrayList<String> firstTableResults;
    public ArrayList<String> secondTableResults;
    public ArrayList<MatchedPair> matchedTables;
    private static final String blankTable = "<table><tr><td></td></tr></table>";

    public String getFileContent(String filePath) {
        try {
            TestExecutionReport report = new TestExecutionReport().read(new File(filePath));
            if (report.getResults().size() != 1) {
                return null;
            }
            return report.getResults().get(0).getContent();
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public double findScoreByFirstTableIndex(int firstIndex) {
        for (MatchedPair match : this.matchedTables) {
            if (match.first != firstIndex) continue;
            return match.matchScore;
        }
        return 0.0;
    }

    public String findScoreByFirstTableIndexAsStringAsPercent(int firstIndex) {
        double score = this.findScoreByFirstTableIndex(firstIndex);
        return String.format("%10.2f", score / 1.2 * 100.0);
    }

    public boolean allTablesMatch() {
        if (this.matchedTables == null || this.matchedTables.size() == 0 || this.firstTableResults == null || this.firstTableResults.size() == 0) {
            return false;
        }
        if (this.matchedTables.size() == this.firstTableResults.size()) {
            for (MatchedPair match : this.matchedTables) {
                if (!(match.matchScore < 1.19)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean compare(String firstFilePath, String secondFilePath) throws Exception {
        if (firstFilePath.equals(secondFilePath)) {
            return false;
        }
        this.initializeFileContents(firstFilePath, secondFilePath);
        return this.grabAndCompareTablesFromHtml();
    }

    public boolean grabAndCompareTablesFromHtml() throws ParserException {
        this.initializeComparerHelpers();
        if (this.firstScanner.getTableCount() == 0 || this.secondScanner.getTableCount() == 0) {
            return false;
        }
        this.comparer = new TableListComparer(this.firstScanner, this.secondScanner);
        this.comparer.compareAllTables();
        this.matchedTables = this.comparer.tableMatches;
        this.getTableTextFromScanners();
        this.lineUpTheTables();
        this.addBlanksToUnmatchingRows();
        this.makePassFailResultsFromMatches();
        return true;
    }

    private void initializeComparerHelpers() throws ParserException {
        this.matchedTables = new ArrayList();
        resultContent = new ArrayList();
        this.firstScanner = new HtmlTableScanner(this.firstFileContent);
        this.secondScanner = new HtmlTableScanner(this.secondFileContent);
    }

    public void lineUpTheTables() {
        for (int currentMatch = 0; currentMatch < this.matchedTables.size(); ++currentMatch) {
            this.lineUpMatch(currentMatch);
        }
        this.lineUpLastRow();
    }

    private void lineUpMatch(int currentMatch) {
        this.insertBlanksUntilMatchLinesUp(new FirstResultAdjustmentStrategy(), currentMatch);
        this.insertBlanksUntilMatchLinesUp(new SecondResultAdjustmentStrategy(), currentMatch);
    }

    private void insertBlanksUntilMatchLinesUp(ResultAdjustmentStrategy adjustmentStrategy, int currentMatch) {
        while (adjustmentStrategy.matchIsNotLinedUp(currentMatch)) {
            adjustmentStrategy.insertBlankTableBefore(currentMatch);
            this.incrementRemaingMatchesToCompensateForInsertion(adjustmentStrategy, currentMatch);
        }
    }

    private void incrementRemaingMatchesToCompensateForInsertion(ResultAdjustmentStrategy adjustmentStrategy, int currentMatch) {
        for (int matchToAdjust = currentMatch; matchToAdjust < this.matchedTables.size(); ++matchToAdjust) {
            this.matchedTables.set(matchToAdjust, adjustmentStrategy.getAdjustedMatch(matchToAdjust));
        }
    }

    private void lineUpLastRow() {
        while (this.firstTableResults.size() > this.secondTableResults.size()) {
            this.secondTableResults.add(blankTable);
        }
        while (this.secondTableResults.size() > this.firstTableResults.size()) {
            this.firstTableResults.add(blankTable);
        }
    }

    public void addBlanksToUnmatchingRows() {
        for (int tableIndex = 0; tableIndex < this.firstTableResults.size(); ++tableIndex) {
            if (!this.tablesDontMatchAndArentBlank(tableIndex)) continue;
            this.insetBlanksToSplitTheRow(tableIndex);
            this.incrementMatchedPairsIfBelowTheInsertedBlank(tableIndex);
        }
    }

    private boolean tablesDontMatchAndArentBlank(int tableIndex) {
        return !this.thereIsAMatchForTableWithIndex(tableIndex) && this.firstAndSecondTableAreNotBlank(tableIndex);
    }

    private boolean thereIsAMatchForTableWithIndex(int tableIndex) {
        return this.findScoreByFirstTableIndex(tableIndex) > 0.1;
    }

    private boolean firstAndSecondTableAreNotBlank(int tableIndex) {
        return !this.firstTableResults.get(tableIndex).equals(blankTable) && !this.secondTableResults.get(tableIndex).equals(blankTable);
    }

    private void incrementMatchedPairsIfBelowTheInsertedBlank(int tableIndex) {
        for (int j = 0; j < this.matchedTables.size(); ++j) {
            MatchedPair match = this.matchedTables.get(j);
            if (match.first <= tableIndex) continue;
            this.matchedTables.set(j, new MatchedPair(match.first + 1, match.second + 1, match.matchScore));
        }
    }

    private void insetBlanksToSplitTheRow(int tableIndex) {
        this.secondTableResults.add(tableIndex, blankTable);
        this.firstTableResults.add(tableIndex + 1, blankTable);
    }

    private void getTableTextFromScanners() {
        int i;
        this.firstTableResults = new ArrayList();
        this.secondTableResults = new ArrayList();
        for (i = 0; i < this.firstScanner.getTableCount(); ++i) {
            this.firstTableResults.add(this.firstScanner.getTable(i).toHtml());
        }
        for (i = 0; i < this.secondScanner.getTableCount(); ++i) {
            this.secondTableResults.add(this.secondScanner.getTable(i).toHtml());
        }
    }

    public void makePassFailResultsFromMatches() {
        for (int i = 0; i < this.firstTableResults.size(); ++i) {
            String result = "fail";
            for (MatchedPair match : this.matchedTables) {
                if (match.first != i || !(match.matchScore >= 1.19)) continue;
                result = "pass";
            }
            resultContent.add(result);
        }
    }

    private void initializeFileContents(String firstFilePath, String secondFilePath) throws ParserException {
        String content = this.getFileContent(firstFilePath);
        this.firstFileContent = content == null ? "" : content;
        content = this.getFileContent(secondFilePath);
        this.secondFileContent = content == null ? "" : content;
    }

    public ArrayList<String> getResultContent() {
        return resultContent;
    }

    private class SecondResultAdjustmentStrategy
    implements ResultAdjustmentStrategy {
        private SecondResultAdjustmentStrategy() {
        }

        public boolean matchIsNotLinedUp(int matchIndex) {
            MatchedPair matchedPair = HistoryComparer.this.matchedTables.get(matchIndex);
            return matchedPair.first > matchedPair.second;
        }

        public void insertBlankTableBefore(int matchIndex) {
            HistoryComparer.this.secondTableResults.add(HistoryComparer.this.matchedTables.get((int)matchIndex).second, HistoryComparer.blankTable);
        }

        public MatchedPair getAdjustedMatch(int matchIndex) {
            MatchedPair matchedPair = HistoryComparer.this.matchedTables.get(matchIndex);
            return new MatchedPair(matchedPair.first, matchedPair.second + 1, matchedPair.matchScore);
        }
    }

    private class FirstResultAdjustmentStrategy
    implements ResultAdjustmentStrategy {
        private FirstResultAdjustmentStrategy() {
        }

        public boolean matchIsNotLinedUp(int matchIndex) {
            MatchedPair matchedPair = HistoryComparer.this.matchedTables.get(matchIndex);
            return matchedPair.first < matchedPair.second;
        }

        public void insertBlankTableBefore(int matchIndex) {
            HistoryComparer.this.firstTableResults.add(HistoryComparer.this.matchedTables.get((int)matchIndex).first, HistoryComparer.blankTable);
        }

        public MatchedPair getAdjustedMatch(int matchIndex) {
            MatchedPair matchedPair = HistoryComparer.this.matchedTables.get(matchIndex);
            return new MatchedPair(matchedPair.first + 1, matchedPair.second, matchedPair.matchScore);
        }
    }

    private static interface ResultAdjustmentStrategy {
        public boolean matchIsNotLinedUp(int var1);

        public void insertBlankTableBefore(int var1);

        public MatchedPair getAdjustedMatch(int var1);
    }

    static class MatchedPair {
        int first;
        int second;
        public double matchScore;

        public MatchedPair(Integer first, Integer second, double matchScore) {
            this.first = first;
            this.second = second;
            this.matchScore = matchScore;
        }

        public String toString() {
            return "[first: " + this.first + ", second: " + this.second + ", matchScore: " + this.matchScore + "]";
        }

        public int hashCode() {
            return this.first + this.second;
        }

        public boolean equals(Object obj) {
            return this.equals((MatchedPair)obj);
        }

        public boolean equals(MatchedPair match) {
            return this.first == match.first && this.second == match.second;
        }
    }
}

