/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.testHistory;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.VelocityFactory;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.ErrorResponder;
import fitnesse.responders.templateUtilities.PageTitle;
import fitnesse.responders.testHistory.HistoryComparer;
import fitnesse.wiki.PathParser;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Set;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryComparerResponder
implements Responder {
    public HistoryComparer comparer;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private VelocityContext velocityContext;
    private String firstFileName = "";
    private String secondFileName = "";
    private String firstFilePath;
    private String secondFilePath;
    public boolean testing = false;
    private int count;
    private FitNesseContext context;

    public HistoryComparerResponder(HistoryComparer historyComparer) {
        this.comparer = historyComparer;
    }

    public HistoryComparerResponder() {
        this.comparer = new HistoryComparer();
    }

    @Override
    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        this.context = context;
        this.initializeReponseComponents(request);
        if (!this.getFileNameFromRequest(request)) {
            return this.makeErrorResponse(context, request, "Compare Failed because the wrong number of Input Files were given. Select two please.");
        }
        this.firstFilePath = this.composeFileName(request, this.firstFileName);
        this.secondFilePath = this.composeFileName(request, this.secondFileName);
        if (!this.filesExist()) {
            return this.makeErrorResponse(context, request, "Compare Failed because the files were not found.");
        }
        return this.makeResponseFromComparison(context, request);
    }

    private Response makeResponseFromComparison(FitNesseContext context, Request request) throws Exception {
        if (this.comparer.compare(this.firstFilePath, this.secondFilePath)) {
            return this.makeValidResponse();
        }
        String message = String.format("These files could not be compared.  They might be suites, or something else might be wrong.", new Object[0]);
        return this.makeErrorResponse(context, request, message);
    }

    private boolean filesExist() {
        return new File(this.firstFilePath).exists() || new File(this.secondFilePath).exists();
    }

    private void initializeReponseComponents(Request request) throws IOException {
        if (this.comparer == null) {
            this.comparer = new HistoryComparer();
        }
        this.velocityContext = new VelocityContext();
        this.velocityContext.put("pageTitle", (Object)this.makePageTitle(request.getResource()));
    }

    private String composeFileName(Request request, String fileName) {
        return this.context.getTestHistoryDirectory().getPath() + File.separator + request.getResource() + File.separator + fileName;
    }

    private boolean getFileNameFromRequest(Request request) {
        this.firstFileName = "";
        this.secondFileName = "";
        Map<String, Object> inputs = request.getMap();
        Set<String> keys = inputs.keySet();
        return this.setFileNames(keys);
    }

    private boolean setFileNames(Set<String> keys) {
        for (String key : keys) {
            if (!key.contains("TestResult_") || !this.setFileNames(key)) continue;
            return false;
        }
        return !this.firstFileName.equals("") && !this.secondFileName.equals("");
    }

    private boolean setFileNames(String key) {
        if (this.firstFileName.equals("")) {
            this.firstFileName = key.substring(key.indexOf("_") + 1);
        } else if (this.secondFileName.equals("")) {
            this.secondFileName = key.substring(key.indexOf("_") + 1);
        } else {
            return true;
        }
        return false;
    }

    private Response makeValidResponse() throws Exception {
        this.count = 0;
        if (!this.testing) {
            this.velocityContext.put("firstFileName", (Object)this.dateFormat.parse(this.firstFileName));
            this.velocityContext.put("secondFileName", (Object)this.dateFormat.parse(this.secondFileName));
            this.velocityContext.put("completeMatch", (Object)this.comparer.allTablesMatch());
            this.velocityContext.put("comparer", (Object)this.comparer);
        }
        this.velocityContext.put("resultContent", this.comparer.getResultContent());
        this.velocityContext.put("firstTables", this.comparer.firstTableResults);
        this.velocityContext.put("secondTables", this.comparer.secondTableResults);
        this.velocityContext.put("count", (Object)this.count);
        String velocityTemplate = "compareHistory.vm";
        Template template = VelocityFactory.getVelocityEngine().getTemplate(velocityTemplate);
        return this.makeResponseFromTemplate(template);
    }

    private Response makeResponseFromTemplate(Template template) throws Exception {
        StringWriter writer = new StringWriter();
        SimpleResponse response = new SimpleResponse();
        template.merge((Context)this.velocityContext, (Writer)writer);
        response.setContent(writer.toString());
        return response;
    }

    private PageTitle makePageTitle(String resource) {
        return new PageTitle("Test History", PathParser.parse(resource));
    }

    private Response makeErrorResponse(FitNesseContext context, Request request, String message) throws Exception {
        return new ErrorResponder(message).makeResponse(context, request);
    }
}

