/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.testHistory;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.ErrorResponder;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import util.FileUtil;

public class PurgeHistoryResponder
implements SecureResponder {
    private File resultsDirectory;
    private Date todaysDate;

    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        this.initializeResponder(context);
        if (this.hasValidInputs(request)) {
            this.purgeHistory(request);
            return this.makeValidResponse();
        }
        return this.makeErrorResponse(context, request);
    }

    private void initializeResponder(FitNesseContext context) {
        if (this.resultsDirectory == null) {
            this.resultsDirectory = context.getTestHistoryDirectory();
        }
        this.todaysDate = new Date();
    }

    private SimpleResponse makeValidResponse() throws Exception {
        SimpleResponse response = new SimpleResponse();
        response.redirect("?testHistory");
        return response;
    }

    private void purgeHistory(Request request) throws ParseException {
        int days = this.getDaysInput(request);
        this.deleteTestHistoryOlderThanDays(days);
    }

    private Integer getDaysInput(Request request) {
        String daysInput = request.getInput("days").toString();
        return this.parseInt(daysInput);
    }

    private Integer parseInt(String daysInput) {
        try {
            return Integer.parseInt(daysInput);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private boolean hasValidInputs(Request request) {
        return request.getInput("days") != null && this.getDaysInput(request) >= 0;
    }

    private Response makeErrorResponse(FitNesseContext context, Request request) throws Exception {
        return new ErrorResponder("Invalid Amount Of Days").makeResponse(context, request);
    }

    public void setResultsDirectory(File directory) {
        this.resultsDirectory = directory;
    }

    public void setTodaysDate(Date date) {
        this.todaysDate = date;
    }

    public void deleteTestHistoryOlderThanDays(int days) throws ParseException {
        File[] files;
        Date purgeOlder = this.getDateDaysEarlier(days);
        for (File file : files = FileUtil.getDirectoryListing(this.resultsDirectory)) {
            this.deleteFileIfAppropriate(purgeOlder, file);
        }
    }

    public Date getDateDaysEarlier(int days) {
        long now = this.todaysDate.getTime();
        long millisecondsPerDay = 86400000L;
        Date daysEarlier = new Date(now - millisecondsPerDay * (long)days);
        return daysEarlier;
    }

    private void deleteFileIfAppropriate(Date purgeOlder, File file) {
        if (file.isDirectory()) {
            File[] files;
            for (File childFile : files = FileUtil.getDirectoryListing(file)) {
                this.deleteFileIfAppropriate(purgeOlder, childFile);
            }
            if (file.list().length == 0) {
                FileUtil.deleteFileSystemDirectory(file);
            }
        } else {
            this.deleteFileIfItIsTooOld(purgeOlder, file);
        }
    }

    private void deleteFileIfItIsTooOld(Date purgeOlder, File file) {
        String name = file.getName();
        Date date = this.getDateFromPageHistoryFileName(name);
        if (date.getTime() < purgeOlder.getTime()) {
            FileUtil.deleteFile(file);
        }
    }

    private Date getDateFromPageHistoryFileName(String name) {
        Date date;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            date = dateFormat.parse(name.split("_")[0]);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return date;
    }

    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

