/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.testHistory;

import fitnesse.responders.run.TestSummary;
import fitnesse.responders.testHistory.PageHistory;
import fitnesse.wikitext.widgets.WikiWordWidget;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestHistory {
    Map<String, File> pageDirectoryMap = new HashMap<String, File>();
    public static final String TEST_RESULT_FILE_DATE_PATTERN = "yyyyMMddHHmmss";

    public void readHistoryDirectory(File historyDirectory) {
        File[] pageDirectories;
        for (File file : pageDirectories = FileUtil.getDirectoryListing(historyDirectory)) {
            if (!this.isValidFile(file)) continue;
            this.pageDirectoryMap.put(file.getName(), file);
        }
    }

    private boolean isValidFile(File file) {
        return file.isDirectory() && file.list().length > 0 && WikiWordWidget.isWikiWord(file.getName());
    }

    public Set<String> getPageNames() {
        return new TreeSet<String>(this.pageDirectoryMap.keySet());
    }

    public PageHistory getPageHistory(String pageName) {
        File pageHistoryDirectory = this.pageDirectoryMap.get(pageName);
        if (pageHistoryDirectory == null) {
            return null;
        }
        PageHistory pageHistory = new PageHistory(pageHistoryDirectory);
        if (pageHistory.size() == 0) {
            return null;
        }
        return pageHistory;
    }

    public void readPageHistoryDirectory(File historyDirectory, String pageName) {
        File[] pageDirectories;
        for (File file : pageDirectories = FileUtil.getDirectoryListing(historyDirectory)) {
            if (!this.isValidFile(file) || !file.getName().startsWith(pageName)) continue;
            this.pageDirectoryMap.put(file.getName(), file);
        }
    }

    public static String makeResultFileName(TestSummary summary, long time) {
        SimpleDateFormat format = new SimpleDateFormat(TEST_RESULT_FILE_DATE_PATTERN);
        String datePart = format.format(new Date(time));
        return String.format("%s_%d_%d_%d_%d.xml", datePart, summary.getRight(), summary.getWrong(), summary.getIgnores(), summary.getExceptions());
    }
}

