/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.runner;

import fit.Counts;
import fit.FitProtocol;
import fitnesse.components.ContentBuffer;
import fitnesse.responders.run.TestSummary;
import fitnesse.runner.PageResult;
import fitnesse.runner.ResultFormatter;
import fitnesse.runner.ResultHandler;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CachingResultFormatter
implements ResultFormatter {
    private ContentBuffer buffer;
    public List<ResultHandler> subHandlers = new LinkedList<ResultHandler>();

    public CachingResultFormatter() throws Exception {
        this.buffer = new ContentBuffer(".results");
    }

    public void acceptResult(PageResult result) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        FitProtocol.writeData(result.toString() + "\n", (OutputStream)output);
        this.buffer.append(output.toByteArray());
        Iterator<ResultHandler> iterator = this.subHandlers.iterator();
        while (iterator.hasNext()) {
            iterator.next().acceptResult(result);
        }
    }

    public void acceptFinalCount(TestSummary testSummary) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Counts counts = new Counts(testSummary.getRight(), testSummary.getWrong(), testSummary.getIgnores(), testSummary.getExceptions());
        FitProtocol.writeCounts(counts, output);
        this.buffer.append(output.toByteArray());
        Iterator<ResultHandler> iterator = this.subHandlers.iterator();
        while (iterator.hasNext()) {
            iterator.next().acceptFinalCount(testSummary);
        }
    }

    public int getByteCount() throws Exception {
        return this.buffer.getSize();
    }

    public InputStream getResultStream() throws Exception {
        return this.buffer.getNonDeleteingInputStream();
    }

    public void cleanUp() throws Exception {
        this.buffer.delete();
    }

    public void addHandler(ResultHandler handler) {
        this.subHandlers.add(handler);
    }
}

