/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.runner;

import fitnesse.responders.run.TestSummary;
import fitnesse.runner.PageResult;
import fitnesse.runner.ResultHandler;
import java.io.InputStream;
import java.io.PrintStream;

public class StandardResultHandler
implements ResultHandler {
    private PrintStream output;
    private TestSummary pageCounts = new TestSummary();

    public StandardResultHandler(PrintStream output) {
        this.output = output;
    }

    public void acceptResult(PageResult result) throws Exception {
        TestSummary testSummary = result.testSummary();
        this.pageCounts.tallyPageCounts(testSummary);
        for (int i = 0; i < testSummary.getRight(); ++i) {
            this.output.print(".");
        }
        if (testSummary.getWrong() > 0 || testSummary.getExceptions() > 0) {
            this.output.println();
            if (testSummary.getWrong() > 0) {
                this.output.println(this.pageDescription(result) + " has failures");
            }
            if (testSummary.getExceptions() > 0) {
                this.output.println(this.pageDescription(result) + " has errors");
            }
        }
    }

    private String pageDescription(PageResult result) {
        String description = result.title();
        if ("".equals(description)) {
            description = "The test";
        }
        return description;
    }

    public void acceptFinalCount(TestSummary testSummary) throws Exception {
        this.output.println();
        this.output.println("Test Pages: " + this.pageCounts);
        this.output.println("Assertions: " + testSummary);
    }

    public int getByteCount() {
        return 0;
    }

    public InputStream getResultStream() throws Exception {
        return null;
    }
}

