/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.runner;

import fitnesse.http.RequestBuilder;
import fitnesse.responders.run.TestSummary;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.CommandLine;
import util.StreamReader;
import util.StringUtil;
import util.XmlUtil;

public class TestRunner {
    private String outputFileName;
    private String host;
    private int port;
    private String pageName;
    private PrintStream output;
    private String suiteFilter = null;
    private String excludeSuiteFilter = null;
    private String credentials = null;
    private StreamReader socketReader;
    private Document testResultsDocument;
    private TestSummary counts;
    private boolean verbose;
    private boolean debug = false;
    private String request;
    private String xmlDocumentString;

    public TestRunner() throws Exception {
        this(System.out);
    }

    public TestRunner(PrintStream output) throws Exception {
        this.output = output;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("***************************************");
        System.out.println("THIS TEST RUNNER HAS BEEN DEPRECATED!!!");
        System.out.println("Use java -jar fitnesse.jar -c \"REST-COMMAND\" instead.");
        System.out.println("***************************************");
        TestRunner runner = new TestRunner();
        runner.run(args);
        System.exit(runner.exitCode());
    }

    public void args(String[] args) throws Exception {
        CommandLine commandLine = new CommandLine("[-v] [-debug] [-xml file] [-suiteFilter filter] [-excludeSuiteFilter excludeFilter] [-credentials userpass] host port pageName");
        if (!commandLine.parse(args)) {
            this.usage();
        }
        this.host = commandLine.getArgument("host");
        this.port = Integer.parseInt(commandLine.getArgument("port"));
        this.pageName = commandLine.getArgument("pageName");
        if (commandLine.hasOption("v")) {
            this.verbose = true;
        }
        if (commandLine.hasOption("debug")) {
            this.debug = true;
        }
        if (commandLine.hasOption("xml")) {
            this.outputFileName = commandLine.getOptionArgument("xml", "file");
        }
        if (commandLine.hasOption("suiteFilter")) {
            this.suiteFilter = commandLine.getOptionArgument("suiteFilter", "filter");
        }
        if (commandLine.hasOption("excludeSuiteFilter")) {
            this.excludeSuiteFilter = commandLine.getOptionArgument("excludeSuiteFilter", "excludeFilter");
        }
        if (commandLine.hasOption("credentials")) {
            this.credentials = commandLine.getOptionArgument("credentials", "userpass");
        }
    }

    private void usage() {
        System.out.println("usage: java fitnesse.runner.TestRunner [options] host port page-name");
        System.out.println("\t-v\tPrint test results.");
        System.out.println("\t-xml <file>\t Write XML test results to file.  If file is 'stdout' write to standard out");
        System.out.println("\t-suiteFilter <filter> \texecutes only tests which are flagged with the given filter");
        System.out.println("\t-credentials <user:pwd> \tAuthenticates with given credentials when sending commands to the server");
        System.exit(-1);
    }

    public void run(String[] args) throws Exception {
        this.args(args);
        this.debug(String.format("Args: %s", StringUtil.join(Arrays.asList(args), " ")));
        this.requestTest();
        this.debug(String.format("Sent request: %s", this.request));
        this.discardHeaders();
        this.xmlDocumentString = this.getXmlDocument();
        this.debug(String.format("Xml Document: %s", this.xmlDocumentString));
        this.testResultsDocument = XmlUtil.newDocument(this.xmlDocumentString);
        this.debug("Xml Document Parsed");
        this.gatherCounts();
        this.writeOutputFile();
        this.verboseOutput();
        this.debug(String.format("Exit Code: %d", this.exitCode()));
    }

    private void debug(String message) {
        if (this.debug) {
            this.output.println(message);
        }
    }

    private void verboseOutput() throws Exception {
        if (this.verbose) {
            TestSummary pageCounts = new TestSummary();
            TestSummary suiteSummary = new TestSummary();
            Element testResultsElement = this.testResultsDocument.getDocumentElement();
            String rootPath = XmlUtil.getTextValue(testResultsElement, "rootPath");
            this.output.println(String.format("Test Runner for Root Path: %s", rootPath));
            NodeList results = testResultsElement.getElementsByTagName("result");
            for (int i = 0; i < results.getLength(); ++i) {
                Element result = (Element)results.item(i);
                TestSummary pageSummary = this.showResult(result);
                suiteSummary.add(pageSummary);
                pageCounts.tallyPageCounts(pageSummary);
            }
            this.output.println("Test Pages: " + pageCounts);
            this.output.println("Assertions: " + suiteSummary);
        }
    }

    private TestSummary showResult(Element result) throws Exception {
        String page = XmlUtil.getTextValue(result, "relativePageName");
        Element counts = XmlUtil.getElementByTagName(result, "counts");
        int right = Integer.parseInt(XmlUtil.getTextValue(counts, "right"));
        int wrong = Integer.parseInt(XmlUtil.getTextValue(counts, "wrong"));
        int ignores = Integer.parseInt(XmlUtil.getTextValue(counts, "ignores"));
        int exceptions = Integer.parseInt(XmlUtil.getTextValue(counts, "exceptions"));
        String pageHistoryLink = XmlUtil.getTextValue(result, "pageHistoryLink");
        TestSummary testSummary = new TestSummary(right, wrong, ignores, exceptions);
        String marker = wrong > 0 || exceptions > 0 ? "*" : " ";
        this.output.println(String.format("%s Page:%s right:%d, wrong:%d, ignored:%d, exceptions:%d | %s", marker, page, right, wrong, ignores, exceptions, pageHistoryLink));
        return testSummary;
    }

    private void writeOutputFile() throws Exception {
        if (this.outputFileName != null) {
            this.debug(String.format("Writing: %s", this.outputFileName));
            OutputStream os = this.getOutputStream();
            os.write(this.xmlDocumentString.getBytes());
            os.close();
        } else {
            this.debug("No output file to write.");
        }
    }

    private OutputStream getOutputStream() throws FileNotFoundException {
        if ("stdout".equalsIgnoreCase(this.outputFileName)) {
            return this.output;
        }
        return new FileOutputStream(this.outputFileName);
    }

    private void gatherCounts() throws Exception {
        this.debug("Gathering Counts...");
        Element testResults = this.testResultsDocument.getDocumentElement();
        Element finalCounts = XmlUtil.getElementByTagName(testResults, "finalCounts");
        String right = XmlUtil.getTextValue(finalCounts, "right");
        String wrong = XmlUtil.getTextValue(finalCounts, "wrong");
        String ignores = XmlUtil.getTextValue(finalCounts, "ignores");
        String exceptions = XmlUtil.getTextValue(finalCounts, "exceptions");
        this.counts = new TestSummary(Integer.parseInt(right), Integer.parseInt(wrong), Integer.parseInt(ignores), Integer.parseInt(exceptions));
        this.debug(String.format("Counts: %s", this.counts.toString()));
    }

    public int exitCode() {
        int exitStatus = 0;
        if (this.counts.getWrong() > 0) {
            ++exitStatus;
        }
        if (this.counts.getExceptions() > 0) {
            ++exitStatus;
        }
        return exitStatus;
    }

    private String getXmlDocument() throws Exception {
        StringBuffer xmlDocumentBuffer = new StringBuffer();
        while (true) {
            String sizeLine;
            if ((sizeLine = this.socketReader.readLine()).equals("")) {
                continue;
            }
            int size = Integer.parseInt(sizeLine, 16);
            if (size == 0) break;
            String chunk = this.socketReader.read(size);
            xmlDocumentBuffer.append(chunk);
        }
        return xmlDocumentBuffer.toString();
    }

    private void discardHeaders() throws Exception {
        String line;
        do {
            line = this.socketReader.readLine();
            this.debug("Discarding header: " + line);
        } while (!line.equals(""));
    }

    private void requestTest() throws Exception {
        Socket socket = new Socket(this.host, this.port);
        OutputStream socketOutput = socket.getOutputStream();
        this.socketReader = new StreamReader(socket.getInputStream());
        this.request = this.makeHttpRequest();
        byte[] bytes = this.request.getBytes("UTF-8");
        socketOutput.write(bytes);
        socketOutput.flush();
    }

    public String makeHttpRequest() throws Exception {
        String requestUrl = this.makeRequestUrl();
        return this.buildRequestFromUrl(requestUrl);
    }

    private String buildRequestFromUrl(String requestUrl) throws Exception {
        RequestBuilder requestBuilder = new RequestBuilder(requestUrl);
        if (this.credentialsSpecified()) {
            String[] userPass = this.credentials.split(":");
            requestBuilder.addCredentials(userPass[0], userPass[1]);
        }
        return requestBuilder.getText();
    }

    private boolean credentialsSpecified() {
        return this.credentials != null;
    }

    private String makeRequestUrl() {
        String requestUrl = "/" + this.pageName + "?responder=suite";
        if (this.suiteFilter != null) {
            requestUrl = requestUrl + "&suiteFilter=" + this.suiteFilter;
        }
        if (this.excludeSuiteFilter != null) {
            requestUrl = requestUrl + "&excludeSuiteFilter=" + this.excludeSuiteFilter;
        }
        requestUrl = requestUrl + "&format=xml";
        return requestUrl;
    }

    public TestSummary getCounts() throws Exception {
        return this.counts;
    }
}

