/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.runner;

import fitnesse.components.ContentBuffer;
import fitnesse.responders.run.TestSummary;
import fitnesse.runner.PageResult;
import fitnesse.runner.ResultFormatter;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.XmlUtil;
import util.XmlWriter;

public class XmlResultFormatter
implements ResultFormatter {
    private ContentBuffer buffer = new ContentBuffer(".xml");
    private Document document;
    private boolean closed = false;
    private byte[] tailBytes;

    public XmlResultFormatter(String host, String rootPath) throws Exception {
        this.createDocument(host, rootPath);
        this.writeDocumentHeader();
    }

    private void writeDocumentHeader() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        XmlWriter writer = new XmlWriter(output);
        writer.write(this.document);
        writer.close();
        String xmlText = output.toString();
        int endIndex = xmlText.indexOf("</testResults>");
        String head = xmlText.substring(0, endIndex);
        String tail = xmlText.substring(endIndex);
        this.tailBytes = tail.getBytes();
        this.buffer.append(head);
    }

    private void createDocument(String host, String rootPath) throws Exception {
        this.document = XmlUtil.newDocument();
        Element root = this.document.createElement("testResults");
        this.document.appendChild(root);
        XmlUtil.addTextNode(this.document, root, "host", host);
        XmlUtil.addTextNode(this.document, root, "rootPath", rootPath);
    }

    public void acceptResult(PageResult result) throws Exception {
        Element resultElement = this.document.createElement("result");
        XmlUtil.addTextNode(this.document, resultElement, "relativePageName", result.title());
        XmlUtil.addCdataNode(this.document, resultElement, "content", result.content());
        resultElement.appendChild(this.makeCountsElement("counts", result.testSummary()));
        this.writeElement(resultElement);
    }

    public void acceptFinalCount(TestSummary testSummary) throws Exception {
        Element countsElement = this.makeCountsElement("finalCounts", testSummary);
        this.writeElement(countsElement);
    }

    public int getByteCount() throws Exception {
        this.close();
        return this.buffer.getSize();
    }

    public InputStream getResultStream() throws Exception {
        this.close();
        return this.buffer.getInputStream();
    }

    private void close() throws Exception {
        if (!this.closed) {
            this.buffer.append(this.tailBytes);
            this.closed = true;
        }
    }

    private void writeElement(Element resultElement) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        XmlWriter writer = new XmlWriter(output);
        writer.write(resultElement, 1);
        writer.close();
        this.buffer.append(output.toByteArray());
    }

    private Element makeCountsElement(String name, TestSummary testSummary) {
        Element countsElement = this.document.createElement(name);
        XmlUtil.addTextNode(this.document, countsElement, "right", testSummary.getRight() + "");
        XmlUtil.addTextNode(this.document, countsElement, "wrong", testSummary.getWrong() + "");
        XmlUtil.addTextNode(this.document, countsElement, "ignores", testSummary.getIgnores() + "");
        XmlUtil.addTextNode(this.document, countsElement, "exceptions", testSummary.getExceptions() + "");
        return countsElement;
    }
}

