/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.Converter;
import fitnesse.slim.Slim;
import fitnesse.slim.SlimError;
import fitnesse.slim.converters.PropertyEditorConverter;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConverterSupport {
    ConverterSupport() {
    }

    public static Converter getConverter(Class<?> k) {
        Converter c = Slim.converters.get(k);
        if (c != null) {
            return c;
        }
        PropertyEditor pe = PropertyEditorManager.findEditor(k);
        if (pe != null) {
            return new PropertyEditorConverter(pe);
        }
        return null;
    }

    public static Object[] convertArgs(Object[] args, Class<?>[] argumentTypes) {
        Object[] convertedArgs = new Object[args.length];
        for (int i = 0; i < argumentTypes.length; ++i) {
            Class<?> argumentType = argumentTypes[i];
            if (argumentType == List.class && args[i] instanceof List) {
                convertedArgs[i] = args[i];
                continue;
            }
            Converter converter = ConverterSupport.getConverter(argumentType);
            if (converter != null) {
                convertedArgs[i] = converter.fromString((String)args[i]);
                continue;
            }
            throw new SlimError(String.format("message:<<NO_CONVERTER_FOR_ARGUMENT_NUMBER %s.>>", argumentType.getName()));
        }
        return convertedArgs;
    }
}

