/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.SlimError;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListDeserializer {
    private ArrayList<Object> result;
    private String serialized;
    private int index = 0;

    public static List<Object> deserialize(String serialized) {
        return new ListDeserializer(serialized).deserialize();
    }

    public ListDeserializer(String serialized) {
        this.serialized = serialized;
    }

    public List<Object> deserialize() {
        try {
            this.checkSerializedStringIsValid();
            return this.deserializeString();
        }
        catch (Exception e) {
            throw new SyntaxError((Throwable)e);
        }
    }

    private void checkSerializedStringIsValid() {
        if (this.serialized == null) {
            throw new SyntaxError("Can't deserialize null");
        }
        if (this.serialized.length() == 0) {
            throw new SyntaxError("Can't deserialize empty string");
        }
    }

    private List<Object> deserializeString() {
        this.checkForOpenBracket();
        List<Object> result = this.deserializeList();
        this.checkForClosedBracket();
        return result;
    }

    private void checkForClosedBracket() {
        if (!this.charsLeft() || this.getChar() != ']') {
            throw new SyntaxError("Serialized list has no ending ]");
        }
    }

    private boolean charsLeft() {
        return this.index < this.serialized.length();
    }

    private void checkForOpenBracket() {
        if (this.getChar() != '[') {
            throw new SyntaxError("Serialized list has no starting [");
        }
    }

    private List<Object> deserializeList() {
        this.result = new ArrayList();
        int itemCount = this.getLength();
        for (int i = 0; i < itemCount; ++i) {
            this.deserializeItem();
        }
        return this.result;
    }

    private void deserializeItem() {
        int itemLength = this.getLength();
        String item = this.getString(itemLength);
        try {
            List<Object> sublist = ListDeserializer.deserialize(item);
            this.result.add(sublist);
        }
        catch (SyntaxError e) {
            this.result.add(item);
        }
    }

    private String getString(int length) {
        String result = this.serialized.substring(this.index, this.index + length);
        this.index += length;
        this.checkForColon("String");
        return result;
    }

    private void checkForColon(String itemType) {
        if (this.getChar() != ':') {
            throw new SyntaxError(itemType + " in serialized list not terminated by colon.");
        }
    }

    private char getChar() {
        return this.serialized.charAt(this.index++);
    }

    private int getLength() {
        try {
            return this.tryGetLength();
        }
        catch (NumberFormatException e) {
            throw new SyntaxError((Throwable)e);
        }
    }

    private int tryGetLength() {
        int lengthSize = 6;
        String lengthString = this.serialized.substring(this.index, this.index + lengthSize);
        int length = Integer.parseInt(lengthString);
        this.index += lengthSize;
        this.checkForColon("Length");
        return length;
    }

    public class SyntaxError
    extends SlimError {
        private static final long serialVersionUID = 1L;

        public SyntaxError(String s) {
            super(s);
        }

        public SyntaxError(Throwable e) {
            super(e);
        }
    }
}

