/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.NameTranslator;
import fitnesse.slim.SlimFactory;
import fitnesse.slim.Statement;
import fitnesse.slim.StatementExecutorInterface;
import java.util.ArrayList;
import java.util.List;
import util.ListUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListExecutor {
    private StatementExecutorInterface executor;
    private NameTranslator methodNameTranslator;
    private boolean verbose;

    public ListExecutor(SlimFactory slimFactory) throws Exception {
        this(false, slimFactory);
    }

    protected ListExecutor(boolean verbose, SlimFactory slimFactory) throws Exception {
        this.verbose = verbose;
        this.executor = slimFactory.getStatementExecutor();
        this.methodNameTranslator = slimFactory.getMethodNameTranslator();
    }

    public List<Object> execute(List<Object> statements) {
        String message = "!1 Instructions";
        this.verboseMessage(message);
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object statement : statements) {
            List<Object> statementList = ListUtility.uncheckedCast(Object.class, statement);
            this.verboseMessage(statementList + "\n");
            Object retVal = new Statement(statementList, this.methodNameTranslator).execute(this.executor);
            this.verboseMessage(retVal);
            this.verboseMessage("------");
            result.add(retVal);
            if (!this.executor.stopHasBeenRequested()) continue;
            this.executor.reset();
            return result;
        }
        return result;
    }

    private void verboseMessage(Object message) {
        if (this.verbose) {
            System.out.println(message);
        }
    }
}

