/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.SlimError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodExecutionResult {
    public static final MethodExecutionResult NO_METHOD_IN_LIBRARIES = new MethodExecutionResult(null){

        public boolean hasResult() {
            return false;
        }
    };
    private final Object result;

    MethodExecutionResult(Object result) {
        this.result = result;
    }

    public static MethodExecutionResult noMethod(String methodName, Class<?> clazz, int numberOfArgs) {
        return new NoMethod(methodName, clazz, numberOfArgs);
    }

    public static MethodExecutionResult noInstance(String instanceName) {
        return new NoInstance(instanceName);
    }

    public boolean hasResult() {
        return true;
    }

    public Object returnValue() {
        return this.result;
    }

    public boolean hasMethod() {
        return !(this instanceof NoMethod);
    }

    private static class NoInstance
    extends MethodExecutionResult {
        private final String instanceName;

        NoInstance(String instanceName) {
            super(null);
            this.instanceName = instanceName;
        }

        public Object returnValue() {
            throw new SlimError(String.format("message:<<NO_INSTANCE %s.>>", this.instanceName));
        }

        public boolean hasResult() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoMethod
    extends MethodExecutionResult {
        static final String MESSAGE_NO_METHOD_IN_CLASS = "message:<<NO_METHOD_IN_CLASS %s[%d] %s.>>";
        private final int numberOfArgs;
        private final String methodName;
        private final Class<?> clazz;

        @Override
        public boolean hasResult() {
            return false;
        }

        public NoMethod(String methodName, Class<?> clazz, int numberOfArgs) {
            super(null);
            this.methodName = methodName;
            this.clazz = clazz;
            this.numberOfArgs = numberOfArgs;
        }

        @Override
        public Object returnValue() {
            throw new SlimError(String.format(MESSAGE_NO_METHOD_IN_CLASS, this.methodName, this.numberOfArgs, this.clazz.getName()));
        }
    }
}

