/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.Converter;
import fitnesse.slim.ConverterSupport;
import fitnesse.slim.MethodExecutionResult;
import fitnesse.slim.SlimError;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MethodExecutor {
    public abstract MethodExecutionResult execute(String var1, String var2, Object[] var3) throws Throwable;

    protected Method findMatchingMethod(String methodName, Class<? extends Object> k, int nArgs) {
        Method[] methods;
        for (Method method : methods = k.getMethods()) {
            boolean hasMatchingArguments;
            boolean hasMatchingName = method.getName().equals(methodName);
            boolean bl = hasMatchingArguments = method.getParameterTypes().length == nArgs;
            if (!hasMatchingName || !hasMatchingArguments) continue;
            return method;
        }
        return null;
    }

    protected Object invokeMethod(Object instance, Method method, Object[] args) throws Throwable {
        Object[] convertedArgs = this.convertArgs(method, args);
        Object retval = this.callMethod(instance, method, convertedArgs);
        Class<?> retType = method.getReturnType();
        if (retType == List.class && retval instanceof List) {
            return retval;
        }
        return this.convertToString(retval, retType);
    }

    private Object[] convertArgs(Method method, Object[] args) {
        Class<?>[] argumentTypes = method.getParameterTypes();
        Object[] convertedArgs = this.convertArgs(args, argumentTypes);
        return convertedArgs;
    }

    private Object callMethod(Object instance, Method method, Object[] convertedArgs) throws Throwable {
        Object retval = null;
        try {
            retval = method.invoke(instance, convertedArgs);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        return retval;
    }

    private Object[] convertArgs(Object[] args, Class<?>[] argumentTypes) {
        Object[] convertedArgs = new Object[args.length];
        for (int i = 0; i < argumentTypes.length; ++i) {
            Class<?> argumentType = argumentTypes[i];
            if (argumentType == List.class && args[i] instanceof List) {
                convertedArgs[i] = args[i];
                continue;
            }
            Converter converter = ConverterSupport.getConverter(argumentType);
            if (converter != null) {
                convertedArgs[i] = converter.fromString((String)args[i]);
                continue;
            }
            throw new SlimError(String.format("message:<<NO_CONVERTER_FOR_ARGUMENT_NUMBER %s.>>", argumentType.getName()));
        }
        return convertedArgs;
    }

    private Object convertToString(Object retval, Class<?> retType) {
        Converter converter = ConverterSupport.getConverter(retType);
        if (converter != null) {
            return converter.toString(retval);
        }
        if (retval == null) {
            return "null";
        }
        return retval.toString();
    }

    protected MethodExecutionResult findAndInvoke(String methodName, Object[] args, Object instance) throws Throwable {
        Method method = this.findMatchingMethod(methodName, instance.getClass(), args.length);
        if (method != null) {
            return new MethodExecutionResult(this.invokeMethod(instance, method, args));
        }
        return MethodExecutionResult.noMethod(methodName, instance.getClass(), args.length);
    }
}

