/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.ListDeserializer;
import fitnesse.slim.ListExecutor;
import fitnesse.slim.ListSerializer;
import fitnesse.slim.SlimFactory;
import fitnesse.slim.SlimService;
import fitnesse.slim.SlimVersion;
import fitnesse.socketservice.SocketServer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.List;
import util.StreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlimServer
implements SocketServer {
    private StreamReader reader;
    private BufferedWriter writer;
    private ListExecutor executor;
    public static final String EXCEPTION_TAG = "__EXCEPTION__:";
    public static final String EXCEPTION_STOP_TEST_TAG = "__EXCEPTION__:ABORT_SLIM_TEST:";
    private boolean verbose;
    private SlimFactory slimFactory;

    public SlimServer(boolean verbose, SlimFactory slimFactory) {
        this.verbose = verbose;
        this.slimFactory = slimFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serve(Socket s) {
        try {
            this.tryProcessInstructions(s);
        }
        catch (Throwable throwable) {
        }
        finally {
            this.slimFactory.stop();
            this.close();
            this.closeEnclosingServiceInSeperateThread();
        }
    }

    private void closeEnclosingServiceInSeperateThread() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    SlimService.instance.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
    }

    private void tryProcessInstructions(Socket s) throws Exception {
        this.initialize(s);
        boolean more = true;
        while (more) {
            more = this.processOneSetOfInstructions();
        }
    }

    private void initialize(Socket s) throws Exception {
        this.executor = this.slimFactory.getListExecutor(this.verbose);
        this.reader = new StreamReader(s.getInputStream());
        this.writer = new BufferedWriter(new OutputStreamWriter(s.getOutputStream(), "UTF-8"));
        this.writer.write(String.format("Slim -- V%s\n", SlimVersion.VERSION));
        this.writer.flush();
    }

    private boolean processOneSetOfInstructions() throws Exception {
        String instructions = this.getInstructionsFromClient();
        if (instructions != null) {
            return this.processTheInstructions(instructions);
        }
        return true;
    }

    private boolean processTheInstructions(String instructions) throws IOException {
        if (instructions.equalsIgnoreCase("bye")) {
            return false;
        }
        List<Object> results = this.executeInstructions(instructions);
        this.sendResultsToClient(results);
        return true;
    }

    private String getInstructionsFromClient() throws Exception {
        int instructionLength = Integer.parseInt(this.reader.read(6));
        this.reader.read(1);
        String instructions = this.reader.read(instructionLength);
        return instructions;
    }

    private List<Object> executeInstructions(String instructions) {
        List<Object> statements = ListDeserializer.deserialize(instructions);
        List<Object> results = this.executor.execute(statements);
        return results;
    }

    private void sendResultsToClient(List<Object> results) throws IOException {
        String resultString = ListSerializer.serialize(results);
        this.writer.write(String.format("%06d:%s", resultString.getBytes("UTF-8").length, resultString));
        this.writer.flush();
    }

    private void close() {
        try {
            this.reader.close();
            this.writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

