/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.Converter;
import fitnesse.slim.ConverterSupport;
import fitnesse.slim.FixtureMethodExecutor;
import fitnesse.slim.Library;
import fitnesse.slim.LibraryMethodExecutor;
import fitnesse.slim.MethodExecutionResult;
import fitnesse.slim.MethodExecutionResults;
import fitnesse.slim.MethodExecutor;
import fitnesse.slim.Slim;
import fitnesse.slim.SlimError;
import fitnesse.slim.StatementExecutorInterface;
import fitnesse.slim.SystemUnderTestMethodExecutor;
import fitnesse.slim.VariableStore;
import fitnesse.slim.converters.BooleanArrayConverter;
import fitnesse.slim.converters.BooleanConverter;
import fitnesse.slim.converters.CharConverter;
import fitnesse.slim.converters.DateConverter;
import fitnesse.slim.converters.DoubleArrayConverter;
import fitnesse.slim.converters.DoubleConverter;
import fitnesse.slim.converters.IntConverter;
import fitnesse.slim.converters.IntegerArrayConverter;
import fitnesse.slim.converters.ListConverter;
import fitnesse.slim.converters.MapEditor;
import fitnesse.slim.converters.StringArrayConverter;
import fitnesse.slim.converters.StringConverter;
import fitnesse.slim.converters.VoidConverter;
import java.beans.PropertyEditorManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementExecutor
implements StatementExecutorInterface {
    private Map<String, Object> instances = new HashMap<String, Object>();
    private List<Library> libraries = new ArrayList<Library>();
    private List<MethodExecutor> executorChain = new ArrayList<MethodExecutor>();
    private VariableStore variables = new VariableStore();
    private List<String> paths = new ArrayList<String>();
    private boolean stopRequested = false;

    public StatementExecutor() {
        Slim.addConverter(Void.TYPE, new VoidConverter());
        Slim.addConverter(String.class, new StringConverter());
        Slim.addConverter(Integer.TYPE, new IntConverter());
        Slim.addConverter(Double.TYPE, new DoubleConverter());
        Slim.addConverter(Integer.class, new IntConverter());
        Slim.addConverter(Double.class, new DoubleConverter());
        Slim.addConverter(Character.TYPE, new CharConverter());
        Slim.addConverter(Boolean.TYPE, new BooleanConverter());
        Slim.addConverter(Boolean.class, new BooleanConverter());
        Slim.addConverter(Date.class, new DateConverter());
        Slim.addConverter(List.class, new ListConverter());
        Slim.addConverter(Integer[].class, new IntegerArrayConverter());
        Slim.addConverter(int[].class, new IntegerArrayConverter());
        Slim.addConverter(String[].class, new StringArrayConverter());
        Slim.addConverter(boolean[].class, new BooleanArrayConverter());
        Slim.addConverter(Boolean[].class, new BooleanArrayConverter());
        Slim.addConverter(double[].class, new DoubleArrayConverter());
        Slim.addConverter(Double[].class, new DoubleArrayConverter());
        PropertyEditorManager.registerEditor(Map.class, MapEditor.class);
        this.executorChain.add(new FixtureMethodExecutor(this.instances));
        this.executorChain.add(new SystemUnderTestMethodExecutor(this.instances));
        this.executorChain.add(new LibraryMethodExecutor(this.libraries));
    }

    @Override
    public void setVariable(String name, Object value) {
        this.variables.setVariable(name, value);
    }

    @Override
    public Object addPath(String path) {
        this.paths.add(path);
        return "OK";
    }

    @Override
    public Object getInstance(String instanceName) {
        Object instance = this.instances.get(instanceName);
        if (instance != null) {
            return instance;
        }
        for (Library library : this.libraries) {
            if (!library.instanceName.equals(instanceName)) continue;
            return library.instance;
        }
        throw new SlimError(String.format("message:<<NO_INSTANCE %s.>>", instanceName));
    }

    public Converter getConverter(Class<?> k) {
        return ConverterSupport.getConverter(k);
    }

    @Override
    public Object create(String instanceName, String className, Object[] args) {
        try {
            Object instance = this.createInstanceOfConstructor(className, this.replaceVariables(args));
            if (this.isLibrary(instanceName)) {
                this.libraries.add(new Library(instanceName, instance));
            } else {
                this.instances.put(instanceName, instance);
            }
            return "OK";
        }
        catch (SlimError e) {
            return this.couldNotInvokeConstructorException(className, args);
        }
        catch (IllegalArgumentException e) {
            return this.couldNotInvokeConstructorException(className, args);
        }
        catch (Throwable e) {
            return this.exceptionToString(e);
        }
    }

    private boolean isLibrary(String instanceName) {
        return instanceName.startsWith("library");
    }

    private String couldNotInvokeConstructorException(String className, Object[] args) {
        return this.exceptionToString(new SlimError(String.format("message:<<COULD_NOT_INVOKE_CONSTRUCTOR %s[%d]>>", className, args.length)));
    }

    private Object createInstanceOfConstructor(String className, Object[] args) throws Exception {
        Class<?> k = this.searchPathsForClass(className);
        Constructor<?> constructor = this.getConstructor(k.getConstructors(), args);
        if (constructor == null) {
            throw new SlimError(String.format("message:<<NO_CONSTRUCTOR %s>>", className));
        }
        return constructor.newInstance(ConverterSupport.convertArgs(args, constructor.getParameterTypes()));
    }

    private Class<?> searchPathsForClass(String className) {
        Class<?> k = this.getClass(className);
        if (k != null) {
            return k;
        }
        ArrayList<String> reversedPaths = new ArrayList<String>(this.paths);
        Collections.reverse(reversedPaths);
        for (String path : reversedPaths) {
            k = this.getClass(path + "." + className);
            if (k == null) continue;
            return k;
        }
        throw new SlimError(String.format("message:<<NO_CLASS %s>>", className));
    }

    private Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Constructor<?> getConstructor(Constructor<?>[] constructors, Object[] args) {
        for (Constructor<?> constructor : constructors) {
            Class<?>[] arguments = constructor.getParameterTypes();
            if (arguments.length != args.length) continue;
            return constructor;
        }
        return null;
    }

    @Override
    public Object call(String instanceName, String methodName, Object ... args) {
        try {
            MethodExecutionResults results = new MethodExecutionResults();
            for (int i = 0; i < this.executorChain.size(); ++i) {
                MethodExecutionResult result = this.executorChain.get(i).execute(instanceName, methodName, this.replaceVariables(args));
                if (result.hasResult()) {
                    return result.returnValue();
                }
                results.add(result);
            }
            return results.returnValue();
        }
        catch (Throwable e) {
            return this.exceptionToString(e);
        }
    }

    private Object[] replaceVariables(Object[] args) {
        return this.variables.replaceVariables(args);
    }

    private String exceptionToString(Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter pw = new PrintWriter(stringWriter);
        exception.printStackTrace(pw);
        if (exception.getClass().toString().contains("StopTest")) {
            this.stopRequested = true;
            return "__EXCEPTION__:ABORT_SLIM_TEST:" + stringWriter.toString();
        }
        return "__EXCEPTION__:" + stringWriter.toString();
    }

    @Override
    public boolean stopHasBeenRequested() {
        return this.stopRequested;
    }

    @Override
    public void reset() {
        this.stopRequested = false;
    }
}

